/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.UnaryOperator;

public class RecordQueue<T>
extends ArrayDeque<T> {
    private final ReentrantLock lock = new ReentrantLock();

    public RecordQueue(int capacityHint) {
        super(capacityHint);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Iterable<T> iterable) {
        this.lock.lock();
        try {
            for (T record : iterable) {
                super.offer(record);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean add(T item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(T item) {
        this.lock.lock();
        try {
            boolean bl = super.offer(item);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T poll() {
        Object record;
        this.lock.lock();
        try {
            record = super.poll();
        }
        finally {
            this.lock.unlock();
        }
        return (T)record;
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    void rewriteQueue(UnaryOperator<T> mapFunction) {
        this.lock.lock();
        try {
            ArrayDeque replacementQueue = new ArrayDeque();
            this.stream().map(mapFunction).filter(Objects::nonNull).forEach(replacementQueue::offer);
            this.clear();
            this.addAll(replacementQueue);
        }
        finally {
            this.lock.unlock();
        }
    }
}

