/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.CacheEntryLocator;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.ImmutableBean;
import org.wildfly.clustering.ejb.bean.ImmutableBeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanGroup;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanGroupManager;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanMetaDataFactory;

public interface ImmutableBeanFactory<K, V extends BeanInstance<K>, M>
extends CacheEntryLocator<K, M> {
    public ImmutableBeanMetaDataFactory<K, M> getMetaDataFactory();

    public ImmutableBeanGroupManager<K, V> getBeanGroupManager();

    default public CompletionStage<M> findValueAsync(K id) {
        return this.getMetaDataFactory().findValueAsync(id);
    }

    default public CompletionStage<M> tryValueAsync(K id) {
        return this.getMetaDataFactory().tryValueAsync(id);
    }

    default public ImmutableBean<K, V> createImmutableBean(K id, M value) {
        ImmutableBeanMetaData<K> metaData = this.getMetaDataFactory().createImmutableBeanMetaData(id, value);
        ImmutableBeanGroup<Object, V> group = this.getBeanGroupManager().getImmutableBeanGroup(metaData.getGroupId());
        return this.createImmutableBean(id, metaData, group);
    }

    public ImmutableBean<K, V> createImmutableBean(K var1, ImmutableBeanMetaData<K> var2, ImmutableBeanGroup<K, V> var3);
}

