/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core;

import io.smallrye.faulttolerance.core.CoreLogger;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;

public final class Invocation<V>
implements FaultToleranceStrategy<V> {
    private static final Invocation<?> INSTANCE = new Invocation();

    public static <V> Invocation<V> invocation() {
        return INSTANCE;
    }

    private Invocation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        CoreLogger.LOG.trace("Guarded method invocation started");
        try {
            Future<V> future = ctx.call();
            return future;
        }
        catch (Exception e) {
            Future future = Future.ofError(e);
            return future;
        }
        finally {
            CoreLogger.LOG.trace("Guarded method invocation finished");
        }
    }
}

