/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async;

import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.async.AsyncLogger;
import io.smallrye.faulttolerance.core.async.ThreadOffloadEnabled;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import java.util.concurrent.Executor;

public class RememberEventLoop<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final EventLoop eventLoop;
    private final ThreadOffloadEnabled defaultEnabled;

    public RememberEventLoop(FaultToleranceStrategy<V> delegate, EventLoop eventLoop, boolean defaultEnabled) {
        this.delegate = delegate;
        this.eventLoop = eventLoop;
        this.defaultEnabled = new ThreadOffloadEnabled(defaultEnabled);
    }

    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        if (ctx.get(ThreadOffloadEnabled.class, this.defaultEnabled).value) {
            return this.delegate.apply(ctx);
        }
        AsyncLogger.LOG.trace("RememberEventLoopExecutor started");
        try {
            if (this.eventLoop.isEventLoopThread()) {
                ctx.set(Executor.class, this.eventLoop.executor());
            }
            Future<V> future = this.delegate.apply(ctx);
            return future;
        }
        finally {
            AsyncLogger.LOG.trace("RememberEventLoopExecutor finished");
        }
    }
}

