/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.httpserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.jboss.wsf.stack.cxf.addons.transports.httpserver.HttpServerEngine;

public class HttpServerEngineFactory
implements BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(HttpServerEngineFactory.class);
    private static Map<Integer, HttpServerEngine> portMap = new HashMap<Integer, HttpServerEngine>();
    private BusLifeCycleManager lifeCycleManager;
    private Bus bus;

    public HttpServerEngineFactory(Bus b) {
        this.setBus(b);
    }

    @Resource(name="cxf")
    public final void setBus(Bus bus) {
        assert (this.bus == null || this.bus == bus);
        this.bus = bus;
        if (bus != null) {
            bus.setExtension((Object)this, HttpServerEngineFactory.class);
            this.lifeCycleManager = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
            if (null != this.lifeCycleManager) {
                this.lifeCycleManager.registerLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HttpServerEngine retrieveHttpServerEngine(int port) {
        HttpServerEngine engine = null;
        Map<Integer, HttpServerEngine> map = portMap;
        synchronized (map) {
            engine = portMap.get(port);
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HttpServerEngine createHttpServerEngine(String host, int port, String protocol) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating HttpServer Engine for port " + port + ".");
        }
        HttpServerEngine ref = null;
        Map<Integer, HttpServerEngine> map = portMap;
        synchronized (map) {
            ref = this.retrieveHttpServerEngine(port);
            if (null == ref) {
                ref = new HttpServerEngine(this, this.bus, host, port);
                portMap.put(port, ref);
            }
            if (!protocol.equals(ref.getProtocol())) {
                throw new IOException("Protocol mismatch for port " + port + ": " + "engine's protocol is " + ref.getProtocol() + ", the url protocol is " + protocol);
            }
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyForPort(int port) {
        Map<Integer, HttpServerEngine> map = portMap;
        synchronized (map) {
            HttpServerEngine ref = portMap.remove(port);
            if (ref != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Stopping HttpServer Engine on port " + port + ".");
                }
                try {
                    ref.stop();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "", e);
                }
            }
        }
    }

    public void initComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postShutdown() {
        HttpServerEngine[] engines = null;
        Map<Integer, HttpServerEngine> map = portMap;
        synchronized (map) {
            engines = portMap.values().toArray(new HttpServerEngine[0]);
        }
        for (HttpServerEngine engine : engines) {
            if (engine.getBus() != this.getBus()) continue;
            engine.shutdown();
        }
    }

    public void preShutdown() {
    }
}

