/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RealmSecurityProviderService;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.as.remoting.SimpleHttpUpgradeHandshake;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ExternalConnectionProvider;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.SslConnection;

public class RemotingHttpUpgradeService
implements Service<RemotingHttpUpgradeService> {
    public static final String JBOSS_REMOTING = "jboss-remoting";
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_JBOSS_REMOTING_KEY = "Sec-JbossRemoting-Key";
    public static final String SEC_JBOSS_REMOTING_ACCEPT = "Sec-JbossRemoting-Accept";
    public static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});
    public static final ServiceName UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"remoting ", "remoting-http-upgrade-service"});
    private final String httpConnectorName;
    private final String endpointName;
    private final InjectedValue<ChannelUpgradeHandler> injectedRegistry = new InjectedValue();
    private final InjectedValue<ListenerRegistry> listenerRegistry = new InjectedValue();
    private final InjectedValue<Endpoint> injectedEndpoint = new InjectedValue();
    private final InjectedValue<RemotingSecurityProvider> securityProviderValue = new InjectedValue();
    private final OptionMap connectorPropertiesOptionMap;
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public RemotingHttpUpgradeService(String httpConnectorName, String endpointName, OptionMap connectorPropertiesOptionMap) {
        this.httpConnectorName = httpConnectorName;
        this.endpointName = endpointName;
        this.connectorPropertiesOptionMap = connectorPropertiesOptionMap;
    }

    public static void installServices(ServiceTarget serviceTarget, String remotingConnectorName, String httpConnectorName, ServiceName endpointName, OptionMap connectorPropertiesOptionMap, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        RemotingHttpUpgradeService service = new RemotingHttpUpgradeService(httpConnectorName, endpointName.getSimpleName(), connectorPropertiesOptionMap);
        ServiceName securityProviderName = RealmSecurityProviderService.createName(remotingConnectorName);
        ServiceBuilder builder = serviceTarget.addService(UPGRADE_SERVICE_NAME.append(new String[]{remotingConnectorName}), (Service)service).setInitialMode(ServiceController.Mode.PASSIVE).addDependency(HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}), ChannelUpgradeHandler.class, service.injectedRegistry).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, service.listenerRegistry).addDependency(endpointName, Endpoint.class, service.injectedEndpoint).addDependency(securityProviderName, RemotingSecurityProvider.class, service.securityProviderValue);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        Endpoint endpoint = (Endpoint)this.injectedEndpoint.getValue();
        RemotingSecurityProvider rsp = (RemotingSecurityProvider)this.securityProviderValue.getValue();
        ServerAuthenticationProvider sap = rsp.getServerAuthenticationProvider();
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(rsp.getOptionMap());
        ListenerRegistry.Listener listenerInfo = ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpConnectorName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata(JBOSS_REMOTING, this.endpointName);
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        RemotingConnectorBindingInfoService.install(context.getChildTarget(), context.getController().getName().getSimpleName(), (SocketBinding)listenerInfo.getContextInformation("socket-binding"), listenerInfo.getProtocol().equals("https") ? "https-remoting" : "http-remoting");
        if (this.connectorPropertiesOptionMap != null) {
            builder.addAll(this.connectorPropertiesOptionMap);
        }
        OptionMap resultingMap = builder.getMap();
        try {
            ExternalConnectionProvider provider = (ExternalConnectionProvider)endpoint.getConnectionProviderInterface(Protocol.HTTP_REMOTING.toString(), ExternalConnectionProvider.class);
            final ExternalConnectionProvider.ConnectionAdaptor adaptor = provider.createConnectionAdaptor(resultingMap, sap);
            ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).addProtocol(JBOSS_REMOTING, (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    if (channel instanceof SslConnection) {
                        adaptor.adapt((ConnectedStreamChannel)new AssembledConnectedSslStreamChannel((SslChannel)((SslConnection)channel), (StreamSourceChannel)channel.getSourceChannel(), (StreamSinkChannel)channel.getSinkChannel()));
                    } else {
                        adaptor.adapt((ConnectedStreamChannel)new AssembledConnectedStreamChannel((ConnectedChannel)channel, (StreamSourceChannel)channel.getSourceChannel(), (StreamSinkChannel)channel.getSinkChannel()));
                    }
                }
            }, (HttpUpgradeHandshake)new SimpleHttpUpgradeHandshake(MAGIC_NUMBER, SEC_JBOSS_REMOTING_KEY, SEC_JBOSS_REMOTING_ACCEPT));
        }
        catch (UnknownURISchemeException e) {
            throw new StartException((Throwable)e);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpConnectorName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).removeProtocol(JBOSS_REMOTING);
    }

    public synchronized RemotingHttpUpgradeService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

