/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.File;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.AbstractFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ExposedByteArrayOutputStream;
import org.jboss.as.controller.persistence.FilePersistenceUtils;
import org.jboss.dmr.ModelNode;

public class FilePersistenceResource
extends AbstractFilePersistenceResource {
    protected final File fileName;

    FilePersistenceResource(ModelNode model, File fileName, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        super(model, persister);
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(ExposedByteArrayOutputStream marshalled) {
        File tempFileName = FilePersistenceUtils.createTempFile(this.fileName);
        try {
            FilePersistenceUtils.writeToTempFile(marshalled, tempFileName);
            FilePersistenceUtils.moveTempFileToMain(tempFileName, this.fileName);
        }
        catch (Exception e) {
            ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration(e, this.fileName.getName());
        }
        finally {
            if (tempFileName.exists() && !tempFileName.delete()) {
                ControllerLogger.MGMT_OP_LOGGER.cannotDeleteTempFile(tempFileName.getName());
                tempFileName.deleteOnExit();
            }
        }
    }
}

