/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.AbstractCacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class SessionCacheConfigurationService
extends AbstractCacheConfigurationService {
    private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
    private final InjectedValue<Configuration> configuration = new InjectedValue();
    private final JBossWebMetaData metaData;

    public static ServiceBuilder<Configuration> build(ServiceTarget target, String containerName, String cacheName, String templateCacheName, JBossWebMetaData metaData) {
        SessionCacheConfigurationService service = new SessionCacheConfigurationService(cacheName, metaData);
        return target.addService(CacheConfigurationService.getServiceName((String)containerName, (String)cacheName), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName((String)containerName), EmbeddedCacheManager.class, service.container).addDependency(CacheConfigurationService.getServiceName((String)containerName, (String)templateCacheName), Configuration.class, service.configuration);
    }

    private SessionCacheConfigurationService(String name, JBossWebMetaData metaData) {
        super(name);
        Integer maxActiveSessions;
        ReplicationGranularity granularity;
        this.metaData = metaData;
        ReplicationConfig config = this.metaData.getReplicationConfig();
        if (config == null) {
            config = new ReplicationConfig();
            this.metaData.setReplicationConfig(config);
        }
        if ((granularity = config.getReplicationGranularity()) == null) {
            config.setReplicationGranularity(ReplicationGranularity.SESSION);
        }
        if ((maxActiveSessions = this.metaData.getMaxActiveSessions()) == null) {
            this.metaData.setMaxActiveSessions(Integer.valueOf(-1));
        }
    }

    protected ConfigurationBuilder getConfigurationBuilder() {
        Configuration config = (Configuration)this.configuration.getValue();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(config);
        builder.invocationBatching().enable();
        builder.storeAsBinary().disable().storeKeysAsBinary(false).storeValuesAsBinary(false);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        return builder;
    }

    protected EmbeddedCacheManager getCacheContainer() {
        return (EmbeddedCacheManager)this.container.getValue();
    }
}

