/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import org.hornetq.core.protocol.stomp.HornetQStompException;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="HQ")
public interface HornetQStompProtocolMessageBundle {
    public static final HornetQStompProtocolMessageBundle BUNDLE = (HornetQStompProtocolMessageBundle)Messages.getBundle(HornetQStompProtocolMessageBundle.class);

    @Message(id=339000, value="Stomp Connection TTL cannot be negative: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException negativeConnectionTTL(Long var1);

    @Message(id=339001, value="Destination doesn't exist: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException destinationNotExist(String var1);

    @Message(id=339002, value="Stomp versions not supported: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException versionNotSupported(String var1);

    @Message(id=339003, value="Header host is null", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException nullHostHeader();

    @Message(id=339004, value="Cannot accept null as host", format=Message.Format.MESSAGE_FORMAT)
    public String hostCannotBeNull();

    @Message(id=339005, value="Header host doesn't match server host", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException hostNotMatch();

    @Message(id=339006, value="host {0} doesn't match server host name", format=Message.Format.MESSAGE_FORMAT)
    public String hostNotMatchDetails(String var1);

    @Message(id=339007, value="Connection was destroyed.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException connectionDestroyed();

    @Message(id=339008, value="Connection hasn't been established.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException connectionNotEstablished();

    @Message(id=339009, value="Exception getting session", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorGetSession(@Cause Exception var1);

    @Message(id=339010, value="Connection is not valid.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException invalidConnection();

    @Message(id=339011, value="Error sending message {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorSendMessage(ServerMessageImpl var1, @Cause Exception var2);

    @Message(id=339012, value="Error beginning a transaction {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorBeginTx(String var1, @Cause Exception var2);

    @Message(id=339013, value="Error committing {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorCommitTx(String var1, @Cause Exception var2);

    @Message(id=339014, value="Error aborting {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorAbortTx(String var1, @Cause Exception var2);

    @Message(id=339015, value="Client must set destination or id header to a SUBSCRIBE command", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException noDestination();

    @Message(id=339016, value="Error creating subscription {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorCreatSubscription(String var1, @Cause Exception var2);

    @Message(id=339017, value="Error unsubscribing {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorUnsubscrib(String var1, @Cause Exception var2);

    @Message(id=339018, value="Error acknowledging message {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorAck(String var1, @Cause Exception var2);

    @Message(id=339019, value="Invalid char sequence: two consecutive CRs.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException invalidTwoCRs();

    @Message(id=339020, value="Invalid char sequence: There is a CR not followed by an LF", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException badCRs();

    @Message(id=339021, value="Expect new line char but is {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException notValidNewLine(byte var1);

    @Message(id=339022, value="Expect new line char but is {0}", format=Message.Format.MESSAGE_FORMAT)
    public String unexpectedNewLine(byte var1);

    @Message(id=339023, value="Invalid STOMP frame: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException invalidCommand(String var1);

    @Message(id=339024, value="Invalid STOMP frame: {0}", format=Message.Format.MESSAGE_FORMAT)
    public String invalidFrame(String var1);

    @Message(id=339025, value="failed to ack because no message with id: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException failToAckMissingID(long var1);

    @Message(id=339026, value="subscription id {0} does not match {1}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException subscriptionIDMismatch(String var1, String var2);

    @Message(id=339027, value="Cannot create a subscriber on the durable subscription if the client-id of the connection is not set", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException missingClientID();

    @Message(id=339028, value="Message header too big, increase minLargeMessageSize please.", format=Message.Format.MESSAGE_FORMAT)
    public Exception headerTooBig();

    @Message(id=339029, value="Unsupported command: {0}", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException unknownCommand(String var1);

    @Message(id=339030, value="transaction header is mandatory to COMMIT a transaction", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException needTxIDHeader();

    @Message(id=339031, value="Error handling send", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException errorHandleSend(@Cause Exception var1);

    @Message(id=339032, value="Need a transaction id to begin", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException beginTxNoID();

    @Message(id=339033, value="transaction header is mandatory to ABORT a transaction", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException abortTxNoID();

    @Message(id=339034, value="This method should not be called", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException invalidCall();

    @Message(id=339035, value="Must specify the subscription's id or the destination you are unsubscribing from", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException needIDorDestination();

    @Message(id=339036, value="Encoding error.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException encodingError();

    @Message(id=339037, value="Must specify the subscription's id", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException needSubscriptionID();

    @Message(id=339038, value="Encoding error", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException encodingErrorWithCause(@Cause Exception var1);

    @Message(id=339039, value="No id header in ACK/NACK frame.", format=Message.Format.MESSAGE_FORMAT)
    public HornetQStompException noIDInAck();
}

