/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.security.PermissionFactory;

public class ModuleSpecification
extends SimpleAttachable {
    private final List<ModuleDependency> systemDependencies = new ArrayList<ModuleDependency>();
    private final Set<ModuleIdentifier> systemDependenciesSet = new HashSet<ModuleIdentifier>();
    private final List<ModuleDependency> localDependencies = new ArrayList<ModuleDependency>();
    private boolean localDependenciesTransitive;
    private final List<ModuleDependency> userDependencies = new ArrayList<ModuleDependency>();
    private final List<ResourceLoaderSpec> resourceLoaders = new ArrayList<ResourceLoaderSpec>();
    private final List<String> classFileTransformers = new ArrayList<String>();
    private volatile List<ModuleDependency> allDependencies = null;
    private final Set<ModuleIdentifier> exclusions = new HashSet<ModuleIdentifier>();
    private boolean subDeploymentModulesIsolated;
    private boolean privateModule;
    private boolean localLast;
    private final List<ModuleIdentifier> aliases = new ArrayList<ModuleIdentifier>();
    private final List<DependencySpec> moduleSystemDependencies = new ArrayList<DependencySpec>();
    private final List<PermissionFactory> permissionFactories = new ArrayList<PermissionFactory>();

    public void addSystemDependency(ModuleDependency dependency) {
        if (!this.exclusions.contains(dependency.getIdentifier()) && !this.systemDependenciesSet.contains(dependency.getIdentifier())) {
            this.systemDependencies.add(dependency);
            this.systemDependenciesSet.add(dependency.getIdentifier());
        }
    }

    public void addSystemDependencies(Collection<ModuleDependency> dependencies) {
        this.allDependencies = null;
        for (ModuleDependency dependency : dependencies) {
            this.addSystemDependency(dependency);
        }
    }

    public void addUserDependency(ModuleDependency dependency) {
        this.allDependencies = null;
        this.userDependencies.add(dependency);
    }

    public void addUserDependencies(Collection<ModuleDependency> dependencies) {
        this.allDependencies = null;
        this.userDependencies.addAll(dependencies);
    }

    public void addLocalDependency(ModuleDependency dependency) {
        this.allDependencies = null;
        if (!this.exclusions.contains(dependency.getIdentifier())) {
            this.localDependencies.add(dependency);
        }
    }

    public void addLocalDependencies(Collection<ModuleDependency> dependencies) {
        this.allDependencies = null;
        for (ModuleDependency dependency : dependencies) {
            this.addLocalDependency(dependency);
        }
    }

    public List<ModuleDependency> getSystemDependencies() {
        return Collections.unmodifiableList(this.systemDependencies);
    }

    public void addExclusion(ModuleIdentifier exclusion) {
        ModuleDependency dep;
        this.allDependencies = null;
        this.exclusions.add(exclusion);
        Iterator<ModuleDependency> it = this.systemDependencies.iterator();
        while (it.hasNext()) {
            dep = it.next();
            if (!dep.getIdentifier().equals(exclusion)) continue;
            it.remove();
        }
        it = this.localDependencies.iterator();
        while (it.hasNext()) {
            dep = it.next();
            if (!dep.getIdentifier().equals(exclusion)) continue;
            it.remove();
        }
    }

    public void addExclusions(Iterable<ModuleIdentifier> exclusions) {
        for (ModuleIdentifier exclusion : exclusions) {
            this.addExclusion(exclusion);
        }
    }

    public List<ModuleDependency> getLocalDependencies() {
        return Collections.unmodifiableList(this.localDependencies);
    }

    public List<ModuleDependency> getUserDependencies() {
        return Collections.unmodifiableList(this.userDependencies);
    }

    public List<ModuleDependency> getMutableUserDependencies() {
        this.allDependencies = null;
        return this.userDependencies;
    }

    public void addResourceLoader(ResourceLoaderSpec resourceLoader) {
        this.resourceLoaders.add(resourceLoader);
    }

    public List<ResourceLoaderSpec> getResourceLoaders() {
        return Collections.unmodifiableList(this.resourceLoaders);
    }

    public void addClassFileTransformer(String classFileTransformer) {
        this.classFileTransformers.add(classFileTransformer);
    }

    public List<String> getClassFileTransformers() {
        return Collections.unmodifiableList(this.classFileTransformers);
    }

    public boolean isSubDeploymentModulesIsolated() {
        return this.subDeploymentModulesIsolated;
    }

    public void setSubDeploymentModulesIsolated(boolean subDeploymentModulesIsolated) {
        this.subDeploymentModulesIsolated = subDeploymentModulesIsolated;
    }

    public boolean isPrivateModule() {
        return this.privateModule;
    }

    public void setPrivateModule(boolean privateModule) {
        this.privateModule = privateModule;
    }

    public boolean isLocalDependenciesTransitive() {
        return this.localDependenciesTransitive;
    }

    public void setLocalDependenciesTransitive(boolean localDependenciesTransitive) {
        this.localDependenciesTransitive = localDependenciesTransitive;
    }

    @Deprecated
    public boolean isRequiresTransitiveDependencies() {
        return this.localDependenciesTransitive;
    }

    @Deprecated
    public void setRequiresTransitiveDependencies(boolean requiresTransitiveDependencies) {
        this.localDependenciesTransitive = requiresTransitiveDependencies;
    }

    public boolean isLocalLast() {
        return this.localLast;
    }

    public void setLocalLast(boolean localLast) {
        this.localLast = localLast;
    }

    public void addAlias(ModuleIdentifier moduleIdentifier) {
        this.aliases.add(moduleIdentifier);
    }

    public void addAliases(Collection<ModuleIdentifier> moduleIdentifiers) {
        this.aliases.addAll(moduleIdentifiers);
    }

    public List<ModuleIdentifier> getAliases() {
        return this.aliases;
    }

    public List<ModuleDependency> getAllDependencies() {
        if (this.allDependencies == null) {
            this.allDependencies = new ArrayList<ModuleDependency>();
            this.allDependencies.addAll(this.systemDependencies);
            this.allDependencies.addAll(this.userDependencies);
            this.allDependencies.addAll(this.localDependencies);
        }
        return this.allDependencies;
    }

    public void addModuleSystemDependencies(List<DependencySpec> systemDependencies) {
        this.moduleSystemDependencies.addAll(systemDependencies);
    }

    public List<DependencySpec> getModuleSystemDependencies() {
        return Collections.unmodifiableList(this.moduleSystemDependencies);
    }

    public void addPermissionFactory(PermissionFactory permissionFactory) {
        this.permissionFactories.add(permissionFactory);
    }

    public List<PermissionFactory> getPermissionFactories() {
        return this.permissionFactories;
    }
}

