/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebServerService;

class ServerAdd
extends AbstractBoottimeAddStepHandler {
    ServerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition def : ServerDefinition.ATTRIBUTES) {
            def.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress parentAddress = address.subAddress(0, address.size() - 1);
        ModelNode subsystemModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(parentAddress));
        String name = address.getLastElement().getValue();
        String defaultHost = ServerDefinition.DEFAULT_HOST.resolveModelAttribute(context, model).asString();
        String servletContainer = ServerDefinition.SERVLET_CONTAINER.resolveModelAttribute(context, model).asString();
        String defaultServerName = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, subsystemModel).asString();
        ServiceName serverName = UndertowService.SERVER.append(new String[]{name});
        Server service = new Server(name, defaultHost);
        ServiceBuilder builder = context.getServiceTarget().addService(serverName, (Service)service).addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{servletContainer}), ServletContainerService.class, service.getServletContainerInjector()).addDependency(UndertowService.UNDERTOW, UndertowService.class, service.getUndertowServiceInjector());
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.addListener((ServiceListener)verificationHandler);
        ServiceController serviceController = builder.install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        if (name.equals(defaultServerName)) {
            WebServerService commonWebServer = new WebServerService();
            ServiceBuilder commonServerBuilder = context.getServiceTarget().addService(CommonWebServer.SERVICE_NAME, (Service)commonWebServer).addDependency(serverName, Server.class, commonWebServer.getServerInjectedValue()).setInitialMode(ServiceController.Mode.PASSIVE);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<WebServerService>)commonServerBuilder, UndertowExtension.HTTP_LISTENER_PATH);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<WebServerService>)commonServerBuilder, UndertowExtension.AJP_LISTENER_PATH);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<WebServerService>)commonServerBuilder, UndertowExtension.HTTPS_LISTENER_PATH);
            ServiceController commonServerController = commonServerBuilder.install();
            if (verificationHandler != null) {
                commonServerController.addListener((ServiceListener)verificationHandler);
            }
            if (newControllers != null) {
                newControllers.add(commonServerController);
            }
        }
    }

    private void addCommonHostListenerDeps(OperationContext context, ServiceBuilder<WebServerService> builder, PathElement listenerPath) {
        ModelNode listeners = Resource.Tools.readModel((Resource)context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{listenerPath})), (int)1);
        if (listeners.isDefined()) {
            for (Property p : listeners.asPropertyList()) {
                for (Property listener : p.getValue().asPropertyList()) {
                    builder.addDependency(UndertowService.listenerName(listener.getName()));
                }
            }
        }
    }
}

