/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ThreadSetupAction;
import java.util.Map;
import java.util.Set;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;

public class SecurityContextThreadSetupAction
implements ThreadSetupAction {
    private final String securityDomain;
    private final SecurityDomainContext securityDomainContext;
    private final Map<String, Set<String>> principleVsRoleMap;
    private static final ThreadSetupAction.Handle TEAR_DOWN_ACTION = new ThreadSetupAction.Handle(){

        public void tearDown() {
            SecurityActions.clearSecurityContext();
            SecurityRolesAssociation.setSecurityRoles(null);
        }
    };

    public SecurityContextThreadSetupAction(String securityDomain, SecurityDomainContext securityDomainContext, Map<String, Set<String>> principleVsRoleMap) {
        this.securityDomain = securityDomain;
        this.securityDomainContext = securityDomainContext;
        this.principleVsRoleMap = principleVsRoleMap;
    }

    public ThreadSetupAction.Handle setup(HttpServerExchange exchange) {
        MappingContext mc;
        if (exchange == null) {
            return null;
        }
        SecurityContext sc = (SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT);
        if (sc == null) {
            sc = SecurityActions.createSecurityContext(this.securityDomain);
            exchange.putAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT, (Object)sc);
        }
        SecurityActions.setSecurityContextOnAssociation(sc);
        MappingManager mappingManager = this.securityDomainContext.getMappingManager();
        if (mappingManager != null && (mc = mappingManager.getMappingContext(MappingType.ROLE.name())) != null && mc.hasModules()) {
            SecurityRolesAssociation.setSecurityRoles(this.principleVsRoleMap);
        }
        return TEAR_DOWN_ACTION;
    }
}

