/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ResourceInjectionTarget;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.mail.extension.DirectMailSessionInjectionSource;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.SessionProvider;
import org.jboss.as.mail.extension.SessionProviderFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.MailSessionMetaData;
import org.jboss.metadata.javaee.spec.MailSessionsMetaData;

public class MailSessionDeploymentDescriptorParser
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, ResourceInjectionTarget resourceInjectionTarget, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        MailSessionsMetaData mailSessions = environment.getEnvironment().getMailSessions();
        if (mailSessions != null) {
            ArrayList<BindingConfiguration> ret = new ArrayList<BindingConfiguration>(mailSessions.size());
            for (MailSessionMetaData mailSession : mailSessions) {
                ret.add(this.getBindingConfiguration(mailSession));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public void undeploy(DeploymentUnit context) {
    }

    private BindingConfiguration getBindingConfiguration(MailSessionMetaData mailSession) {
        String jndiName = MailSessionAdd.getJndiName(mailSession.getName());
        SessionProvider provider = SessionProviderFactory.create(mailSession);
        DirectMailSessionInjectionSource source = new DirectMailSessionInjectionSource(jndiName, provider);
        return new BindingConfiguration(jndiName, (InjectionSource)source);
    }
}

