/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.util.ImRModel;

public class ImRServerTableModel
extends AbstractTableModel {
    private ImRModel m_model;
    private static final String[] m_columns = new String[]{"Name", "Host", "Command", "active", "holding"};
    private ServerInfo[] m_servers;

    public ImRServerTableModel(ImRModel model) {
        this.m_model = model;
    }

    public void setServers(ServerInfo[] servers) {
        this.m_servers = servers;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void serverRefreshed(int index) {
        this.fireTableRowsUpdated(index, index);
    }

    public int getRowCount() {
        return this.m_servers.length;
    }

    public int getColumnCount() {
        return m_columns.length;
    }

    public String getColumnName(int column) {
        return m_columns[column];
    }

    public Class getColumnClass(int index) {
        if (index == 0 || index == 1 || index == 2) {
            return String.class;
        }
        if (index == 3 || index == 4) {
            return Boolean.class;
        }
        return Object.class;
    }

    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.m_servers[row].name;
        }
        if (column == 1) {
            return this.m_servers[row].host;
        }
        if (column == 2) {
            return this.m_servers[row].command;
        }
        if (column == 3) {
            return this.m_servers[row].active;
        }
        if (column == 4) {
            return this.m_servers[row].holding;
        }
        return new Object();
    }

    public boolean isCellEditable(int row, int column) {
        return column >= 1;
    }

    public void setValueAt(Object value, int row, int column) {
        this.m_model.updateServer(row, m_columns[column], value);
    }
}

