/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.MessageSupplier;

public class PullMessagesUtility {
    private ScheduledFuture taskId_;
    private long interval_;
    private final TaskProcessor taskProcessor_;
    private final Runnable timerJob_;

    public PullMessagesUtility(final TaskProcessor taskProcessor, final MessageSupplier messageSupplier) {
        this.taskProcessor_ = taskProcessor;
        this.timerJob_ = new Runnable(){

            public void run() {
                taskProcessor.scheduleTimedPullTask(messageSupplier);
            }
        };
    }

    public synchronized void startTask(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("Interval " + interval + " must be > 0");
        }
        if (this.taskId_ == null) {
            this.taskId_ = this.taskProcessor_.executeTaskPeriodically(interval, this.timerJob_, true);
            this.interval_ = interval;
        }
    }

    public synchronized void stopTask() {
        if (this.taskId_ != null) {
            this.taskId_.cancel(true);
            this.taskId_ = null;
        }
    }

    public synchronized void restartTask(long interval) {
        if (this.taskId_ == null) {
            throw new IllegalStateException("Not started");
        }
        if (this.interval_ != interval) {
            this.stopTask();
            this.startTask(interval);
        }
    }
}

