/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.List;
import javax.management.MBeanServer;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.management.ServerConfig;

public final class ServerConfigService
implements Service<ServerConfig> {
    private static final ServiceName MBEAN_SERVER_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    private final AbstractServerConfig serverConfig;

    private ServerConfigService(AbstractServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ServerConfig getValue() {
        return this.serverConfig;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.serverConfig.create();
        }
        catch (Exception e) {
            WSLogger.ROOT_LOGGER.configServiceCreationFailed();
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        try {
            this.serverConfig.destroy();
        }
        catch (Exception e) {
            WSLogger.ROOT_LOGGER.configServiceDestroyFailed();
        }
    }

    public static ServiceController<?> install(ServiceTarget serviceTarget, ServerConfigImpl serverConfig, ServiceListener<Object> listener, List<ServiceName> dependencies, boolean jmxSubsystemAvailable) {
        ServiceBuilder builder = serviceTarget.addService(WSServices.CONFIG_SERVICE, (Service)new ServerConfigService(serverConfig));
        if (jmxSubsystemAvailable) {
            builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, MBEAN_SERVER_NAME, MBeanServer.class, serverConfig.getMBeanServerInjector());
        } else {
            serverConfig.getMBeanServerInjector().setValue((Value)new ImmediateValue(null));
        }
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, serverConfig.getServerEnvironmentInjector());
        for (ServiceName dep : dependencies) {
            builder.addDependency(dep);
        }
        builder.addListener(listener);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController sc = builder.install();
        return sc;
    }
}

