/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.Arrays;
import java.util.HashSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringBytesLengthValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.txn.subsystem.Attribute;
import org.jboss.as.txn.subsystem.TransactionExtension;
import org.jboss.as.txn.subsystem.TransactionSubsystemAdd;
import org.jboss.as.txn.subsystem.TxStatsHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransactionSubsystemRootResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING, false).setValidator((ParameterValidator)new StringLengthValidator(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.BINDING.getLocalName()).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final SimpleAttributeDefinition STATUS_BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("status-socket-binding", ModelType.STRING, false).setValidator((ParameterValidator)new StringLengthValidator(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.STATUS_BINDING.getLocalName()).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final SimpleAttributeDefinition RECOVERY_LISTENER = new SimpleAttributeDefinitionBuilder("recovery-listener", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.RECOVERY_LISTENER.getLocalName()).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition NODE_IDENTIFIER = new SimpleAttributeDefinitionBuilder("node-identifier", ModelType.STRING, true).setDefaultValue(new ModelNode().set("1")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).setValidator((ParameterValidator)new StringBytesLengthValidator(0, 23, true, true)).build();
    public static final SimpleAttributeDefinition PROCESS_ID_UUID = new SimpleAttributeDefinitionBuilder("process-id-uuid", ModelType.BOOLEAN, false).setDefaultValue(new ModelNode().set(false)).setAlternatives(new String[]{"process-id-socket-binding"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    public static final SimpleAttributeDefinition PROCESS_ID_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("process-id-socket-binding", ModelType.STRING, false).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setAlternatives(new String[]{"process-id-uuid"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.BINDING.getLocalName()).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    public static final SimpleAttributeDefinition PROCESS_ID_SOCKET_MAX_PORTS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("process-id-socket-max-ports", ModelType.INT, true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setDefaultValue(new ModelNode().set(10)).setRequires(new String[]{"process-id-socket-binding"}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.SOCKET_PROCESS_ID_MAX_PORTS.getLocalName()).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_CONFIG)).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = new SimpleAttributeDefinitionBuilder(PathResourceDefinition.RELATIVE_TO).setDefaultValue(new ModelNode().set("jboss.server.data.dir")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition PATH = new SimpleAttributeDefinitionBuilder(PathResourceDefinition.PATH).setDefaultValue(new ModelNode().set("var")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowNull(true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition STATISTICS_ENABLED = new SimpleAttributeDefinitionBuilder("statistics-enabled", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ENABLE_STATISTICS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-statistics", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.ENABLE_STATISTICS.getLocalName()).setDeprecated(ModelVersion.create((int)2))).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition ENABLE_TSM_STATUS = new SimpleAttributeDefinitionBuilder("enable-tsm-status", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.ENABLE_TSM_STATUS.getLocalName()).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition DEFAULT_TIMEOUT = new SimpleAttributeDefinitionBuilder("default-timeout", ModelType.INT, true).setMeasurementUnit(MeasurementUnit.SECONDS).setDefaultValue(new ModelNode().set(300)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.DEFAULT_TIMEOUT.getLocalName()).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition OBJECT_STORE_RELATIVE_TO = new SimpleAttributeDefinitionBuilder("object-store-relative-to", ModelType.STRING, true).setDefaultValue(new ModelNode().set("jboss.server.data.dir")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.RELATIVE_TO.getLocalName()).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition OBJECT_STORE_PATH = new SimpleAttributeDefinitionBuilder("object-store-path", ModelType.STRING, true).setDefaultValue(new ModelNode().set("tx-object-store")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setXmlName(Attribute.PATH.getLocalName()).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition JTS = new SimpleAttributeDefinitionBuilder("jts", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setAllowExpression(false).build();
    public static final SimpleAttributeDefinition USEHORNETQSTORE = new SimpleAttributeDefinitionBuilder("use-hornetq-store", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setAlternatives(new String[]{"use-jdbc-store"}).setAllowExpression(false).build();
    public static final SimpleAttributeDefinition HORNETQ_STORE_ENABLE_ASYNC_IO = new SimpleAttributeDefinitionBuilder("hornetq-store-enable-async-io", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.ENABLE_ASYNC_IO.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-hornetq-store"}).build();
    public static final SimpleAttributeDefinition USE_JDBC_STORE = new SimpleAttributeDefinitionBuilder("use-jdbc-store", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setAlternatives(new String[]{"use-hornetq-store"}).setAllowExpression(false).build();
    public static final SimpleAttributeDefinition JDBC_STORE_DATASOURCE = new SimpleAttributeDefinitionBuilder("jdbc-store-datasource", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.DATASOURCE_JNDI_NAME.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-jdbc-store"}).build();
    public static final SimpleAttributeDefinition JDBC_ACTION_STORE_TABLE_PREFIX = new SimpleAttributeDefinitionBuilder("jdbc-action-store-table-prefix", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.TABLE_PREFIX.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-jdbc-store"}).build();
    public static final SimpleAttributeDefinition JDBC_ACTION_STORE_DROP_TABLE = new SimpleAttributeDefinitionBuilder("jdbc-action-store-drop-table", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.DROP_TABLE.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-jdbc-store"}).build();
    public static final SimpleAttributeDefinition JDBC_COMMUNICATION_STORE_TABLE_PREFIX = new SimpleAttributeDefinitionBuilder("jdbc-communication-store-table-prefix", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.TABLE_PREFIX.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-jdbc-store"}).build();
    public static final SimpleAttributeDefinition JDBC_COMMUNICATION_STORE_DROP_TABLE = new SimpleAttributeDefinitionBuilder("jdbc-communication-store-drop-table", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.DROP_TABLE.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-jdbc-store"}).build();
    public static final SimpleAttributeDefinition JDBC_STATE_STORE_TABLE_PREFIX = new SimpleAttributeDefinitionBuilder("jdbc-state-store-table-prefix", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.TABLE_PREFIX.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-jdbc-store"}).build();
    public static final SimpleAttributeDefinition JDBC_STATE_STORE_DROP_TABLE = new SimpleAttributeDefinitionBuilder("jdbc-state-store-drop-table", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_JVM}).setXmlName(Attribute.DROP_TABLE.getLocalName()).setAllowExpression(true).setRequires(new String[]{"use-jdbc-store"}).build();
    private final boolean registerRuntimeOnly;
    static final AttributeDefinition[] attributes = new AttributeDefinition[]{BINDING, STATUS_BINDING, RECOVERY_LISTENER, NODE_IDENTIFIER, PROCESS_ID_UUID, PROCESS_ID_SOCKET_BINDING, PROCESS_ID_SOCKET_MAX_PORTS, RELATIVE_TO, PATH, STATISTICS_ENABLED, ENABLE_TSM_STATUS, DEFAULT_TIMEOUT, OBJECT_STORE_RELATIVE_TO, OBJECT_STORE_PATH, JTS, USEHORNETQSTORE, USE_JDBC_STORE, JDBC_STORE_DATASOURCE, JDBC_ACTION_STORE_DROP_TABLE, JDBC_ACTION_STORE_TABLE_PREFIX, JDBC_COMMUNICATION_STORE_DROP_TABLE, JDBC_COMMUNICATION_STORE_TABLE_PREFIX, JDBC_STATE_STORE_DROP_TABLE, JDBC_STATE_STORE_TABLE_PREFIX, HORNETQ_STORE_ENABLE_ASYNC_IO};
    static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSIONS_AFTER_1_1_0 = new AttributeDefinition[]{DEFAULT_TIMEOUT, STATISTICS_ENABLED, ENABLE_STATISTICS, ENABLE_TSM_STATUS, NODE_IDENTIFIER, OBJECT_STORE_PATH, OBJECT_STORE_RELATIVE_TO, PATH, PROCESS_ID_SOCKET_BINDING, PROCESS_ID_SOCKET_MAX_PORTS, RECOVERY_LISTENER, RELATIVE_TO, BINDING, STATUS_BINDING};
    static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSIONS_AFTER_1_1_1 = new AttributeDefinition[]{JTS, USEHORNETQSTORE};
    static final AttributeDefinition[] attributes_1_2 = new AttributeDefinition[]{USE_JDBC_STORE, JDBC_STORE_DATASOURCE, JDBC_ACTION_STORE_DROP_TABLE, JDBC_ACTION_STORE_TABLE_PREFIX, JDBC_COMMUNICATION_STORE_DROP_TABLE, JDBC_COMMUNICATION_STORE_TABLE_PREFIX, JDBC_STATE_STORE_DROP_TABLE, JDBC_STATE_STORE_TABLE_PREFIX};

    TransactionSubsystemRootResourceDefinition(boolean registerRuntimeOnly) {
        super(TransactionExtension.SUBSYSTEM_PATH, (ResourceDescriptionResolver)TransactionExtension.getResourceDescriptionResolver(new String[0]), (OperationStepHandler)TransactionSubsystemAdd.INSTANCE, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        HashSet<AttributeDefinition> attributesWithoutMutuals = new HashSet<AttributeDefinition>(Arrays.asList(attributes));
        attributesWithoutMutuals.remove(USEHORNETQSTORE);
        attributesWithoutMutuals.remove(USE_JDBC_STORE);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(attributesWithoutMutuals);
        for (AttributeDefinition def : attributesWithoutMutuals) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)writeHandler);
        }
        ObjectStoreMutualWriteHandler mutualWriteHandler = new ObjectStoreMutualWriteHandler(new AttributeDefinition[]{USEHORNETQSTORE, USE_JDBC_STORE});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)USEHORNETQSTORE, null, (OperationStepHandler)mutualWriteHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)USE_JDBC_STORE, null, (OperationStepHandler)mutualWriteHandler);
        EnableStatisticsHandler esh = new EnableStatisticsHandler();
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ENABLE_STATISTICS, (OperationStepHandler)esh, (OperationStepHandler)esh);
        if (this.registerRuntimeOnly) {
            TxStatsHandler.INSTANCE.registerMetrics(resourceRegistration);
        }
    }

    private static class ObjectStoreMutualWriteHandler
    extends ReloadRequiredWriteAttributeHandler {
        public ObjectStoreMutualWriteHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            assert (!USEHORNETQSTORE.isAllowExpression() && !USE_JDBC_STORE.isAllowExpression()) : "rework this before enabling expression";
            if ((attributeName.equals(USEHORNETQSTORE.getName()) || attributeName.equals(USE_JDBC_STORE.getName())) && newValue.asBoolean()) {
                String mutualAttributeName = attributeName.equals(USE_JDBC_STORE.getName()) ? USEHORNETQSTORE.getName() : USE_JDBC_STORE.getName();
                ModelNode resourceModel = model.getModel();
                if (resourceModel.hasDefined(mutualAttributeName) && resourceModel.get(mutualAttributeName).asBoolean()) {
                    resourceModel.get(mutualAttributeName).set(new ModelNode(false));
                }
            }
        }
    }

    private static class EnableStatisticsHandler
    implements OperationStepHandler {
        private EnableStatisticsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode aliased = EnableStatisticsHandler.getAliasedOperation(operation);
            context.addStep(aliased, EnableStatisticsHandler.getHandlerForOperation(context, operation), OperationContext.Stage.MODEL, true);
            context.stepCompleted();
        }

        private static ModelNode getAliasedOperation(ModelNode operation) {
            ModelNode aliased = operation.clone();
            aliased.get("name").set(STATISTICS_ENABLED.getName());
            return aliased;
        }

        private static OperationStepHandler getHandlerForOperation(OperationContext context, ModelNode operation) {
            ImmutableManagementResourceRegistration imrr = context.getResourceRegistration();
            return imrr.getOperationHandler(PathAddress.EMPTY_ADDRESS, operation.get("operation").asString());
        }
    }
}

