/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.AddressableNode;
import org.wildfly.clustering.server.group.ChannelNodeFactory;

public class ChannelNodeFactoryService
extends AbstractService<ChannelNodeFactory>
implements ChannelNodeFactory {
    private final ConcurrentMap<Address, Node> nodes = new ConcurrentHashMap<Address, Node>();
    private final Value<Channel> channel;

    public ChannelNodeFactoryService(Value<Channel> channel) {
        this.channel = channel;
    }

    public Node createNode(Address address) {
        Node existing;
        Node node = (Node)this.nodes.get(address);
        if (node != null) {
            return node;
        }
        Channel channel = (Channel)this.channel.getValue();
        IpAddress ipAddress = (IpAddress)channel.down(new Event(87, (Object)address));
        InetSocketAddress socketAddress = new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort());
        String name = channel.getName(address);
        if (name == null) {
            name = String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort());
        }
        return (existing = this.nodes.putIfAbsent(address, node = new AddressableNode(address, name, socketAddress))) != null ? existing : node;
    }

    public ChannelNodeFactory getValue() {
        return this;
    }

    public void stop(StopContext context) {
        this.nodes.clear();
    }

    @Override
    public void invalidate(Collection<Address> addresses) {
        if (!addresses.isEmpty()) {
            this.nodes.keySet().removeAll(addresses);
        }
    }
}

