/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import java.util.Formatter;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.engine.EndpointError;
import org.apache.qpid.proton.engine.impl.SaslImpl;

class SaslFrameParser {
    private EndpointError _localError;
    private SaslImpl _sasl;
    private State _state = State.SIZE_0;
    private int _size;
    private ByteBuffer _buffer;
    private int _ignore = 8;

    SaslFrameParser(SaslImpl sasl) {
        this._sasl = sasl;
    }

    public int input(byte[] bytes, int offset, int length) {
        int unconsumed = length;
        EndpointError frameParsingError = null;
        int size = this._size;
        State state = this._state;
        ByteBuffer oldIn = null;
        if (this._ignore != 0) {
            if (unconsumed > this._ignore) {
                offset += this._ignore;
                unconsumed -= this._ignore;
                this._ignore = 0;
            } else {
                this._ignore -= length;
                return length;
            }
        }
        ByteBuffer in = ByteBuffer.wrap(bytes, offset, unconsumed);
        while (in.hasRemaining() && state != State.ERROR && !this._sasl.isDone()) {
            switch (state) {
                case SIZE_0: {
                    if (in.remaining() >= 4) {
                        size = in.getInt();
                        state = State.PRE_PARSE;
                        break;
                    }
                    size = in.get() << 24 & 0xFF000000;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_1;
                        break;
                    }
                }
                case SIZE_1: {
                    size |= in.get() << 16 & 0xFF0000;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_2;
                        break;
                    }
                }
                case SIZE_2: {
                    size |= in.get() << 8 & 0xFF00;
                    if (!in.hasRemaining()) {
                        state = State.SIZE_3;
                        break;
                    }
                }
                case SIZE_3: {
                    size |= in.get() & 0xFF;
                    state = State.PRE_PARSE;
                }
                case PRE_PARSE: {
                    if (size < 8) {
                        frameParsingError = this.createFramingError("specified frame size %d smaller than minimum frame header size %d", this._size, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (in.remaining() < size - 4) {
                        this._buffer = ByteBuffer.allocate(size - 4);
                        this._buffer.put(in);
                        state = State.BUFFERING;
                        break;
                    }
                }
                case BUFFERING: {
                    if (this._buffer != null) {
                        if (in.remaining() < this._buffer.remaining()) {
                            this._buffer.put(in);
                            break;
                        }
                        ByteBuffer dup = in.duplicate();
                        dup.limit(dup.position() + this._buffer.remaining());
                        int i = this._buffer.remaining();
                        int d = dup.remaining();
                        in.position(in.position() + this._buffer.remaining());
                        this._buffer.put(dup);
                        oldIn = in;
                        this._buffer.flip();
                        in = this._buffer;
                        state = State.PARSING;
                    }
                }
                case PARSING: {
                    int dataOffset = in.get() << 2 & 0x3FF;
                    if (dataOffset < 8) {
                        frameParsingError = this.createFramingError("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset > size) {
                        frameParsingError = this.createFramingError("specified frame data offset %d larger than the frame size %d", dataOffset, this._size);
                        state = State.ERROR;
                        break;
                    }
                    int type = in.get() & 0xFF;
                    int channel = in.getShort() & 0xFF;
                    if (type != 1) {
                        frameParsingError = this.createFramingError("unknown frame type: %d", type);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset != 8) {
                        in.position(in.position() + dataOffset - 8);
                    }
                    if (oldIn == null) {
                        oldIn = in;
                        in = in.duplicate();
                        int endPos = in.position() + size - dataOffset;
                        in.limit(endPos);
                        oldIn.position(endPos);
                    }
                    try {
                        Binary payload;
                        this._sasl.getDecoder().setByteBuffer(in);
                        Object val = this._sasl.getDecoder().readObject();
                        if (in.hasRemaining()) {
                            byte[] payloadBytes = new byte[in.remaining()];
                            in.get(payloadBytes);
                            payload = new Binary(payloadBytes);
                        } else {
                            payload = null;
                        }
                        if (val instanceof SaslFrameBody) {
                            SaslFrameBody frameBody = (SaslFrameBody)val;
                            frameBody.invoke((SaslFrameBody.SaslFrameBodyHandler)this._sasl, payload, null);
                        }
                        this.reset();
                        in = oldIn;
                        oldIn = null;
                        this._buffer = null;
                        state = State.SIZE_0;
                        break;
                    }
                    catch (DecodeException ex) {
                        state = State.ERROR;
                        frameParsingError = this.createFramingError(ex.getMessage(), new Object[0]);
                    }
                }
            }
        }
        this._state = state;
        this._size = size;
        this._localError = frameParsingError;
        return this._state == State.ERROR ? -1 : length - in.remaining();
    }

    private void reset() {
        this._size = 0;
        this._state = State.SIZE_0;
    }

    private EndpointError createFramingError(String description, Object ... args) {
        Formatter formatter = new Formatter();
        formatter.format(description, args);
        return null;
    }

    static enum State {
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        PRE_PARSE,
        BUFFERING,
        PARSING,
        ERROR;

    }
}

