/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.ws.security.WSSConfig;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.StackConfig;
import org.jboss.wsf.stack.cxf.Loggers;

class CXFStackConfig
implements StackConfig {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CXFStackConfig() {
        ClassLoader orig = CXFStackConfig.getContextClassLoader();
        try {
            CXFStackConfig.setContextClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            WSSConfig.init();
        }
        catch (Exception e) {
            Loggers.ROOT_LOGGER.couldNotInitSecurityEngine();
            Loggers.ROOT_LOGGER.errorGettingWSSConfig((Throwable)e);
        }
        finally {
            CXFStackConfig.setContextClassLoader(orig);
        }
    }

    public String getImplementationTitle() {
        return this.getClass().getPackage().getImplementationTitle();
    }

    public String getImplementationVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
}

