/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.http.HttpConversationContextImpl;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.servlet.ConversationContextActivator;

public class LazyHttpConversationContextImpl
extends HttpConversationContextImpl {
    private final ThreadLocal<Object> initialized = new ThreadLocal();

    public LazyHttpConversationContextImpl(String contextId) {
        super(contextId);
    }

    @Override
    public void activate() {
        if (!this.isActive()) {
            if (!this.isAssociated()) {
                throw ConversationLogger.LOG.mustCallAssociateBeforeActivate();
            }
        } else {
            throw ConversationLogger.LOG.contextAlreadyActive();
        }
        super.setActive(true);
    }

    public boolean isInitialized() {
        return this.initialized.get() != null;
    }

    @Override
    protected void initialize(String cid) {
        this.initialized.set(Boolean.TRUE);
        super.initialize(cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        if (this.isInitialized()) {
            try {
                super.deactivate();
            }
            finally {
                this.initialized.remove();
            }
        }
    }

    @Override
    public boolean destroy(HttpSession session) {
        if (this.isAssociated()) {
            this.checkContextInitialized();
        }
        return super.destroy(session);
    }

    @Override
    protected void checkContextInitialized() {
        if (!this.isInitialized()) {
            this.initialize(ConversationContextActivator.determineConversationId((HttpServletRequest)this.getRequest(), this.getParameterName()));
        }
    }
}

