/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.wildfly.extension.io.WorkerService;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

class WorkerAdd
extends AbstractAddStepHandler {
    static final WorkerAdd INSTANCE = new WorkerAdd();

    private WorkerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (OptionAttributeDefinition attr : WorkerResourceDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        OptionMap.Builder builder = OptionMap.builder();
        for (OptionAttributeDefinition attr : WorkerResourceDefinition.ATTRIBUTES) {
            Option<?> option = attr.getOption();
            ModelNode value = attr.resolveModelAttribute(context, model);
            if (!value.isDefined()) continue;
            if (attr.getType() == ModelType.INT) {
                builder.set(option, value.asInt());
                continue;
            }
            if (attr.getType() == ModelType.LONG) {
                builder.set(option, value.asLong());
                continue;
            }
            if (attr.getType() != ModelType.BOOLEAN) continue;
            builder.set(option, value.asBoolean());
        }
        builder.set(Options.WORKER_NAME, (Object)name);
        ModelNode ioThreadsModel = WorkerResourceDefinition.WORKER_IO_THREADS.resolveModelAttribute(context, model);
        ModelNode maxTaskThreadsModel = WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.resolveModelAttribute(context, model);
        if (!ioThreadsModel.isDefined()) {
            builder.set(WorkerResourceDefinition.WORKER_IO_THREADS.getOption(), Runtime.getRuntime().availableProcessors() * 2);
        }
        if (!maxTaskThreadsModel.isDefined()) {
            builder.set(WorkerResourceDefinition.WORKER_TASK_MAX_THREADS.getOption(), Runtime.getRuntime().availableProcessors() * 16);
        }
        WorkerService workerService = new WorkerService(builder.getMap());
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(IOServices.WORKER.append(new String[]{name}), (Service)workerService);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController serviceController = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
    }
}

