/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.EjbJaccConfig;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class EjbJaccConfigurator
implements ComponentConfigurator {
    private static final String ANY_AUTHENTICATED_USER_ROLE = "**";

    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        SessionBeanComponentDescription session;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)((Object)EJBComponentDescription.class.cast(description));
        EjbJaccConfig ejbJaccConfig = new EjbJaccConfig();
        context.getDeploymentUnit().addToAttachmentList(EjbDeploymentAttachmentKeys.JACC_PERMISSIONS, (Object)ejbJaccConfig);
        for (ViewConfiguration viewConfiguration : configuration.getViews()) {
            List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
            for (Method method : viewMethods) {
                ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions;
                EJBViewConfiguration ejbViewConfiguration;
                boolean createdPerms;
                if (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass() == WriteReplaceInterface.class || (createdPerms = this.createPermissions(ejbJaccConfig, ejbComponentDescription, ejbViewConfiguration = (EJBViewConfiguration)((Object)EJBViewConfiguration.class.cast(viewConfiguration)), method, reflectionIndex, permissions = ejbComponentDescription.getDescriptorMethodPermissions()))) continue;
                permissions = ejbComponentDescription.getAnnotationMethodPermissions();
                this.createPermissions(ejbJaccConfig, ejbComponentDescription, ejbViewConfiguration, method, reflectionIndex, permissions);
            }
        }
        HashSet<String> descriptorRoles = new HashSet<String>();
        SecurityRolesMetaData secRolesMetaData = ejbComponentDescription.getSecurityRoles();
        if (secRolesMetaData != null) {
            for (SecurityRoleMetaData secRoleMetaData : secRolesMetaData) {
                descriptorRoles.add(secRoleMetaData.getRoleName());
            }
        }
        descriptorRoles.add(ANY_AUTHENTICATED_USER_ROLE);
        Map<String, Collection<String>> securityRoles = ejbComponentDescription.getSecurityRoleLinks();
        for (Map.Entry entry : securityRoles.entrySet()) {
            String roleName = (String)entry.getKey();
            for (String roleLink : (Collection)entry.getValue()) {
                EJBRoleRefPermission p = new EJBRoleRefPermission(ejbComponentDescription.getEJBName(), roleName);
                ejbJaccConfig.addRole(roleLink, (Permission)p);
            }
            descriptorRoles.remove(roleName);
        }
        for (String string : descriptorRoles) {
            EJBRoleRefPermission p = new EJBRoleRefPermission(ejbComponentDescription.getEJBName(), string);
            ejbJaccConfig.addRole(string, (Permission)p);
        }
        if (ejbComponentDescription instanceof SessionBeanComponentDescription && (session = (SessionBeanComponentDescription)((Object)SessionBeanComponentDescription.class.cast((Object)ejbComponentDescription))).isStateful()) {
            EJBMethodPermission eJBMethodPermission = new EJBMethodPermission(ejbComponentDescription.getEJBName(), "getEJBObject", "Home", null);
            ejbJaccConfig.addPermit((Permission)eJBMethodPermission);
        }
    }

    protected boolean createPermissions(EjbJaccConfig ejbJaccConfig, EJBComponentDescription description, EJBViewConfiguration ejbViewConfiguration, Method viewMethod, DeploymentReflectionIndex index, ApplicableMethodInformation<EJBMethodSecurityAttribute> permissions) {
        MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)viewMethod);
        EJBMethodSecurityAttribute ejbMethodSecurityMetaData = permissions.getViewAttribute(ejbViewConfiguration.getMethodIntf(), viewMethod);
        if (ejbMethodSecurityMetaData == null) {
            ejbMethodSecurityMetaData = permissions.getViewAttribute(MethodIntf.BEAN, viewMethod);
        }
        Method classMethod = ClassReflectionIndexUtil.findMethod((DeploymentReflectionIndex)index, (Class)ejbViewConfiguration.getComponentConfiguration().getComponentClass(), (Method)viewMethod);
        if (ejbMethodSecurityMetaData == null && classMethod != null) {
            methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)classMethod);
            ejbMethodSecurityMetaData = permissions.getAttribute(ejbViewConfiguration.getMethodIntf(), classMethod);
            if (ejbMethodSecurityMetaData == null) {
                ejbMethodSecurityMetaData = permissions.getAttribute(MethodIntf.BEAN, classMethod);
            }
        }
        if (ejbMethodSecurityMetaData != null) {
            MethodInterfaceType interfaceType = this.getMethodInterfaceType(ejbViewConfiguration.getMethodIntf());
            EJBMethodPermission permission = new EJBMethodPermission(description.getEJBName(), methodIdentifier.getName(), interfaceType.name(), methodIdentifier.getParameterTypes());
            if (ejbMethodSecurityMetaData.isPermitAll()) {
                ejbJaccConfig.addPermit((Permission)permission);
            }
            if (ejbMethodSecurityMetaData.isDenyAll()) {
                ejbJaccConfig.addDeny((Permission)permission);
            }
            for (String role : ejbMethodSecurityMetaData.getRolesAllowed()) {
                ejbJaccConfig.addRole(role, (Permission)permission);
            }
            return true;
        }
        return false;
    }

    protected MethodInterfaceType getMethodInterfaceType(MethodIntf viewType) {
        switch (viewType) {
            case HOME: {
                return MethodInterfaceType.Home;
            }
            case LOCAL_HOME: {
                return MethodInterfaceType.LocalHome;
            }
            case SERVICE_ENDPOINT: {
                return MethodInterfaceType.ServiceEndpoint;
            }
            case LOCAL: {
                return MethodInterfaceType.Local;
            }
            case REMOTE: {
                return MethodInterfaceType.Remote;
            }
            case TIMER: {
                return MethodInterfaceType.Timer;
            }
            case MESSAGE_ENDPOINT: {
                return MethodInterfaceType.MessageEndpoint;
            }
        }
        return null;
    }
}

