/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import java.io.File;
import java.net.InetSocketAddress;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface UndertowLogger
extends BasicLogger {
    public static final UndertowLogger ROOT_LOGGER = (UndertowLogger)Logger.getMessageLogger(UndertowLogger.class, (String)UndertowLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17500, value="Could not initialize JSP")
    public void couldNotInitJsp(@Cause ClassNotFoundException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17501, value="Failed to purge EL cache.")
    public void couldNotPurgeELCache(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17502, value="Undertow %s starting")
    public void serverStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17506, value="Undertow %s stopping")
    public void serverStopping(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17507, value="Secure listener for protocol: '%s' not found! Using non secure port!")
    public void secureListenerNotAvailableForPort(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17519, value="Undertow %s listener %s listening on %s")
    public void listenerStarted(String var1, String var2, InetSocketAddress var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17520, value="Undertow %s listener %s stopped, was bound to %s")
    public void listenerStopped(String var1, String var2, InetSocketAddress var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17521, value="Undertow %s listener %s suspending")
    public void listenerSuspend(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17522, value="Could not load class designated by HandlesTypes [%s].")
    public void cannotLoadDesignatedHandleTypes(ClassInfo var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17523, value="Could not load web socket endpoint %s.")
    public void couldNotLoadWebSocketEndpoint(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17524, value="Could not load web socket application config %s.")
    public void couldNotLoadWebSocketConfig(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17525, value="Started server %s.")
    public void startedServer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17526, value="Could not create redirect URI.")
    public void invalidRedirectURI(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17527, value="Creating file handler for path %s")
    public void creatingFileHandler(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=17528, value="registering handler %s under path '%s'")
    public void registeringHandler(HttpHandler var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17529, value="Could not resolve name in absolute ordering: %s")
    public void invalidAbsoluteOrdering(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17530, value="Could not delete servlet temp file %s")
    public void couldNotDeleteTempFile(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17531, value="Host %s starting")
    public void hostStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17532, value="Host %s stopping")
    public void hostStopping(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17533, value="Clustering not supported, falling back to non-clustered session manager")
    public void clusteringNotSupported();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17534, value="Registered web context: %s")
    public void registerWebapp(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17535, value="Unregistered web context: %s")
    public void unregisterWebapp(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17536, value="Skipped SCI for jar: %s.")
    public void skippedSCI(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17537, value="Failed to persist session attribute %s with value %s for session %s")
    public void failedToPersistSessionAttribute(String var1, Object var2, String var3, @Cause Exception var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17538, value="Failed to register policy context handler for key %s")
    public void failedToRegisterPolicyContextHandler(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17539, value="Error obtaining authorization helper")
    public void noAuthorizationHelper(@Cause Exception var1);
}

