/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.remoting3.Connection;
import org.wildfly.security.manager.WildFlySecurityManager;

final class SecurityActions {
    private SecurityActions() {
    }

    static Connection remotingContextGetConnection() {
        return SecurityActions.remotingContextAssociationActions().getConnection();
    }

    private static RemotingContextAssociationActions remotingContextAssociationActions() {
        return !WildFlySecurityManager.isChecking() ? RemotingContextAssociationActions.NON_PRIVILEGED : RemotingContextAssociationActions.PRIVILEGED;
    }

    private static interface RemotingContextAssociationActions {
        public static final RemotingContextAssociationActions NON_PRIVILEGED = new RemotingContextAssociationActions(){

            @Override
            public Connection getConnection() {
                return RemotingContext.getConnection();
            }
        };
        public static final RemotingContextAssociationActions PRIVILEGED = new RemotingContextAssociationActions(){
            private final PrivilegedAction<Connection> GET_CONNECTION_ACTION = new PrivilegedAction<Connection>(){

                @Override
                public Connection run() {
                    return NON_PRIVILEGED.getConnection();
                }
            };

            @Override
            public Connection getConnection() {
                return AccessController.doPrivileged(this.GET_CONNECTION_ACTION);
            }
        };

        public Connection getConnection();
    }
}

