/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyInfo;
import org.infinispan.distribution.topologyaware.TopologyLevel;
import org.infinispan.remoting.transport.Address;

public class TopologyAwareSyncConsistentHashFactory
extends SyncConsistentHashFactory {
    @Override
    protected Builder createBuilder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        return new Builder(hashFunction, numOwners, numSegments, members, capacityFactors);
    }

    public static class Externalizer
    extends AbstractExternalizer<TopologyAwareSyncConsistentHashFactory> {
        public void writeObject(ObjectOutput output, TopologyAwareSyncConsistentHashFactory chf) {
        }

        public TopologyAwareSyncConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new TopologyAwareSyncConsistentHashFactory();
        }

        public Integer getId() {
            return 54;
        }

        public Set<Class<? extends TopologyAwareSyncConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(TopologyAwareSyncConsistentHashFactory.class);
        }
    }

    protected static class Builder
    extends SyncConsistentHashFactory.Builder {
        protected final TopologyInfo topologyInfo;
        protected TopologyLevel currentLevel;

        protected Builder(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
            super(hashFunction, numOwners, numSegments, members, capacityFactors);
            this.topologyInfo = new TopologyInfo(numSegments, this.actualNumOwners, members, this.capacityFactors);
            this.currentLevel = TopologyLevel.SITE;
        }

        @Override
        protected void copyOwners() {
            this.copyOwnersForLevel(TopologyLevel.SITE);
            this.copyOwnersForLevel(TopologyLevel.RACK);
            this.copyOwnersForLevel(TopologyLevel.MACHINE);
            this.copyOwnersForLevel(TopologyLevel.NODE);
        }

        private void copyOwnersForLevel(TopologyLevel topologyLevel) {
            this.currentLevel = topologyLevel;
            this.ignoreMaxSegments = false;
            super.doCopyOwners();
            this.ignoreMaxSegments = true;
            super.doCopyOwners();
        }

        @Override
        protected boolean addBackupOwner(int segment, Address candidate) {
            if (((Float)this.capacityFactors.get(candidate)).equals(Float.valueOf(0.0f))) {
                return false;
            }
            List owners = this.segmentOwners[segment];
            if (owners.size() < this.actualNumOwners && !this.topologyInfo.duplicateLocation(this.currentLevel, owners, candidate, false)) {
                if (!this.ignoreMaxSegments) {
                    if (owners.isEmpty()) {
                        long maxSegments = Math.round(this.getExpectedPrimarySegments(candidate) * (double)1.05f);
                        if ((long)this.stats.getPrimaryOwned(candidate) < maxSegments) {
                            this.addOwnerNoCheck(segment, candidate);
                            return true;
                        }
                    } else {
                        long maxSegments = Math.round(this.getExpectedOwnedSegments(candidate) * (double)1.1f);
                        if ((long)this.stats.getOwned(candidate) < maxSegments) {
                            this.addOwnerNoCheck(segment, candidate);
                            return true;
                        }
                    }
                } else {
                    this.addOwnerNoCheck(segment, candidate);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean canAddOwners(List<Address> owners) {
            return owners.size() < this.actualNumOwners && owners.size() < this.topologyInfo.getDistinctLocationsCount(this.currentLevel);
        }

        @Override
        protected void populateExtraOwners(int numSegments) {
            this.currentLevel = TopologyLevel.SITE;
            super.populateExtraOwners(numSegments);
            this.currentLevel = TopologyLevel.RACK;
            super.populateExtraOwners(numSegments);
            this.currentLevel = TopologyLevel.MACHINE;
            super.populateExtraOwners(numSegments);
            this.currentLevel = TopologyLevel.NODE;
            super.populateExtraOwners(numSegments);
        }

        @Override
        protected double getExpectedPrimarySegments(Address node) {
            return this.topologyInfo.getExpectedPrimarySegments(node);
        }

        @Override
        protected double getExpectedOwnedSegments(Address node) {
            return this.topologyInfo.getExpectedOwnedSegments(node);
        }
    }
}

