/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;

public class LocalDateTimeExternalizer
implements Externalizer<LocalDateTime> {
    public void writeObject(ObjectOutput output, LocalDateTime dateTime) throws IOException {
        DefaultExternalizer.LOCAL_DATE.cast(LocalDate.class).writeObject(output, (Object)dateTime.toLocalDate());
        DefaultExternalizer.LOCAL_TIME.cast(LocalTime.class).writeObject(output, (Object)dateTime.toLocalTime());
    }

    public LocalDateTime readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        LocalDate date = (LocalDate)DefaultExternalizer.LOCAL_DATE.cast(LocalDate.class).readObject(input);
        LocalTime time = (LocalTime)DefaultExternalizer.LOCAL_TIME.cast(LocalTime.class).readObject(input);
        return LocalDateTime.of(date, time);
    }

    public Class<LocalDateTime> getTargetClass() {
        return LocalDateTime.class;
    }
}

