/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.clustering.context.ExecutorServiceFactory;
import org.jboss.as.clustering.logging.ClusteringLogger;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Invoker;
import org.wildfly.clustering.ee.infinispan.retry.RetryingInvoker;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryListener;
import org.wildfly.clustering.server.logging.ClusteringServerLogger;
import org.wildfly.clustering.server.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.CacheRegistryFilter;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class CacheRegistry<K, V>
implements Registry<K, V>,
CacheEventFilter<Object, Object>,
ExceptionRunnable<CacheException>,
Function<RegistryListener<K, V>, ExecutorService> {
    private final ExecutorService topologyChangeExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(this.getClass()));
    private final Map<RegistryListener<K, V>, ExecutorService> listeners = new ConcurrentHashMap<RegistryListener<K, V>, ExecutorService>();
    private final Cache<Address, Map.Entry<K, V>> cache;
    private final Batcher<? extends Batch> batcher;
    private final org.wildfly.clustering.spi.group.Group<Address> group;
    private final Runnable closeTask;
    private final Map.Entry<K, V> entry;
    private final Invoker invoker;

    public CacheRegistry(CacheRegistryConfiguration<K, V> config, Map.Entry<K, V> entry, Runnable closeTask) {
        this.cache = config.getCache();
        this.batcher = config.getBatcher();
        this.group = config.getGroup();
        this.closeTask = closeTask;
        this.entry = new AbstractMap.SimpleImmutableEntry<K, V>(entry);
        this.invoker = new RetryingInvoker(this.cache);
        this.invoker.invoke((ExceptionRunnable)this);
        this.cache.addListener((Object)this, (CacheEventFilter)CacheRegistryFilter.INSTANCE, null);
    }

    public void run() {
        try (Batch batch = this.batcher.createBatch();){
            this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put(this.group.getAddress(this.group.getLocalMember()), this.entry);
        }
    }

    public boolean accept(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
        return key instanceof Address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block20: {
            this.cache.removeListener((Object)this);
            this.shutdown(this.topologyChangeExecutor);
            try (Batch batch = this.batcher.createBatch();){
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FAIL_SILENTLY}).remove(this.group.getAddress(this.group.getLocalMember()));
            }
            catch (CacheException e) {
                ClusteringLogger.ROOT_LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                break block20;
            }
            finally {
                for (ExecutorService executor : this.listeners.values()) {
                    this.shutdown(executor);
                }
                this.listeners.clear();
                this.closeTask.run();
            }
            for (ExecutorService executor : this.listeners.values()) {
                this.shutdown(executor);
            }
            this.listeners.clear();
            this.closeTask.run();
        }
    }

    public Registration register(RegistryListener<K, V> listener) {
        this.listeners.computeIfAbsent(listener, this);
        return () -> this.unregister(listener);
    }

    @Override
    public ExecutorService apply(RegistryListener<K, V> listener) {
        return new DefaultExecutorService(listener.getClass(), (Function)ExecutorServiceFactory.SINGLE_THREAD);
    }

    private void unregister(RegistryListener<K, V> listener) {
        ExecutorService executor = this.listeners.remove(listener);
        if (executor != null) {
            this.shutdown(executor);
        }
    }

    @Deprecated
    public void removeListener(Registry.Listener<K, V> listener) {
        this.unregister((RegistryListener<K, V>)listener);
    }

    public Group getGroup() {
        return this.group;
    }

    public Map<K, V> getEntries() {
        TreeSet<Object> addresses = new TreeSet<Object>();
        for (Node member : this.group.getMembership().getMembers()) {
            addresses.add(this.group.getAddress(member));
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : this.cache.getAdvancedCache().getAll(addresses).values()) {
            if (entry == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map.Entry<K, V> getEntry(Node node) {
        Address address = (Address)this.group.getAddress(node);
        return (Map.Entry)this.cache.get((Object)address);
    }

    @DataRehashed
    public CompletionStage<Void> dataRehashed(DataRehashedEvent<Address, Map.Entry<K, V>> event) {
        if (!event.isPre()) {
            ConsistentHash previousHash = event.getConsistentHashAtStart();
            List previousMembers = previousHash.getMembers();
            ConsistentHash hash = event.getConsistentHashAtEnd();
            List members = hash.getMembers();
            Address localAddress = (Address)this.group.getAddress(this.group.getLocalMember());
            HashSet leftMembers = new HashSet(previousMembers);
            leftMembers.removeAll(members);
            try {
                this.topologyChangeExecutor.submit(() -> {
                    if (!leftMembers.isEmpty()) {
                        ConsistentHashLocality locality = new ConsistentHashLocality(event.getCache(), hash);
                        Iterator addresses = leftMembers.iterator();
                        while (addresses.hasNext()) {
                            if (locality.isLocal(addresses.next())) continue;
                            addresses.remove();
                        }
                        if (!leftMembers.isEmpty()) {
                            AdvancedCache cache = this.cache.getAdvancedCache().withFlags(Flag.FORCE_SYNCHRONOUS);
                            HashMap removed = new HashMap();
                            try (Batch batch = this.batcher.createBatch();){
                                for (Address leftMember : leftMembers) {
                                    Map.Entry old = (Map.Entry)cache.remove((Object)leftMember);
                                    if (old == null) continue;
                                    removed.put(old.getKey(), old.getValue());
                                }
                            }
                            catch (CacheException e) {
                                ClusteringServerLogger.ROOT_LOGGER.registryPurgeFailed(e, this.cache.getCacheManager().toString(), this.cache.getName(), leftMembers);
                            }
                            if (!removed.isEmpty()) {
                                this.notifyListeners(Event.Type.CACHE_ENTRY_REMOVED, removed);
                            }
                        }
                    } else if (!previousMembers.contains(localAddress)) {
                        try {
                            this.invoker.invoke((ExceptionRunnable)this);
                            this.notifyListeners(Event.Type.CACHE_ENTRY_CREATED, this.entry);
                        }
                        catch (CacheException e) {
                            ClusteringServerLogger.ROOT_LOGGER.failedToRestoreLocalRegistryEntry(e, this.cache.getCacheManager().toString(), this.cache.getName());
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFutures.completedNull();
    }

    @CacheEntryCreated
    @CacheEntryModified
    public CompletionStage<Void> event(CacheEntryEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (!event.isOriginLocal() && !event.isPre() && (entry = (Map.Entry)event.getValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
        return CompletableFutures.completedNull();
    }

    @CacheEntryRemoved
    public CompletionStage<Void> removed(CacheEntryRemovedEvent<Address, Map.Entry<K, V>> event) {
        Map.Entry entry;
        if (!event.isOriginLocal() && !event.isPre() && (entry = (Map.Entry)event.getOldValue()) != null) {
            this.notifyListeners(event.getType(), entry);
        }
        return CompletableFutures.completedNull();
    }

    private void notifyListeners(Event.Type type, Map.Entry<K, V> entry) {
        this.notifyListeners(type, Collections.singletonMap(entry.getKey(), entry.getValue()));
    }

    private void notifyListeners(Event.Type type, Map<K, V> entries) {
        for (Map.Entry<RegistryListener<K, V>, ExecutorService> entry : this.listeners.entrySet()) {
            RegistryListener<K, V> listener = entry.getKey();
            ExecutorService executor = entry.getValue();
            try {
                executor.submit(() -> {
                    try {
                        switch (type) {
                            case CACHE_ENTRY_CREATED: {
                                listener.addedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_MODIFIED: {
                                listener.updatedEntries(entries);
                                break;
                            }
                            case CACHE_ENTRY_REMOVED: {
                                listener.removedEntries(entries);
                                break;
                            }
                            default: {
                                throw new IllegalStateException(type.name());
                            }
                        }
                    }
                    catch (Throwable e) {
                        ClusteringServerLogger.ROOT_LOGGER.registryListenerFailed(e, this.cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName(), this.cache.getName(), type, entries);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void shutdown(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

