/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.function.Predicate;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.scheduler.LinkedScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class BeanExpirationScheduler<I, T>
implements Scheduler<I, ImmutableBeanEntry<I>>,
Predicate<I> {
    private final LocalScheduler<I> scheduler;
    private final Batcher<TransactionBatch> batcher;
    private final BeanFactory<I, T> factory;
    private final ExpirationConfiguration<T> expiration;
    private final BeanRemover<I, T> remover;

    public BeanExpirationScheduler(Group group, Batcher<TransactionBatch> batcher, BeanFactory<I, T> factory, ExpirationConfiguration<T> expiration, BeanRemover<I, T> remover, Duration closeTimeout) {
        LinkedScheduledEntries entries = group.isSingleton() ? new LinkedScheduledEntries() : new SortedScheduledEntries();
        this.scheduler = new LocalScheduler((ScheduledEntries)entries, (Predicate)this, closeTimeout);
        this.batcher = batcher;
        this.factory = factory;
        this.expiration = expiration;
        this.remover = remover;
    }

    public void schedule(I id) {
        BeanEntry entry = (BeanEntry)this.factory.findValue(id);
        if (entry != null) {
            this.schedule(id, entry);
        }
    }

    public void schedule(I id, ImmutableBeanEntry<I> entry) {
        Duration timeout = this.expiration.getTimeout();
        if (!timeout.isNegative()) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Scheduling stateful session bean %s to expire in %s", id, timeout);
            this.scheduler.schedule(id, entry.getLastAccessedTime().plus(timeout));
        }
    }

    public void cancel(I id) {
        this.scheduler.cancel(id);
    }

    public void cancel(Locality locality) {
        for (Object id : this.scheduler) {
            if (Thread.currentThread().isInterrupted()) break;
            if (locality.isLocal(new InfinispanBeanKey(id))) continue;
            this.scheduler.cancel(id);
        }
    }

    public void close() {
        this.scheduler.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean test(I id) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Expiring stateful session bean %s", id);
        try {
            Throwable throwable = null;
            try (Batch batch = this.batcher.createBatch();){
                this.remover.remove(id, this.expiration.getRemoveListener());
                boolean bl = true;
                return bl;
            }
            catch (RuntimeException e) {
                try {
                    batch.discard();
                    throw e;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        catch (RuntimeException e2) {
            InfinispanEjbLogger.ROOT_LOGGER.failedToExpireBean(e2, id);
            return false;
        }
    }
}

