/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.Scanner;
import org.jboss.as.security.vault.VaultInteractiveSession;
import org.jboss.as.security.vault.VaultLogger;
import org.jboss.as.security.vault.VaultSession;

public class VaultInteraction {
    private VaultSession vaultNISession;

    public VaultInteraction(VaultSession vaultSession) {
        this.vaultNISession = vaultSession;
    }

    public void start() {
        Console console = System.console();
        if (console == null) {
            System.err.println(VaultLogger.ROOT_LOGGER.noConsole());
            System.exit(1);
        }
        Scanner in = new Scanner(System.in);
        block11: while (true) {
            String commandStr = VaultLogger.ROOT_LOGGER.interactionCommandOptions();
            System.out.println(commandStr);
            int choice = in.nextInt();
            switch (choice) {
                case 0: {
                    System.out.println(VaultLogger.ROOT_LOGGER.taskStoreSecuredAttribute());
                    char[] attributeValue = VaultInteractiveSession.getSensitiveValue(VaultLogger.ROOT_LOGGER.interactivePromptSecureAttributeValue(), VaultLogger.ROOT_LOGGER.interactivePromptSecureAttributeValueAgain());
                    String vaultBlock = null;
                    while (vaultBlock == null || vaultBlock.length() == 0) {
                        vaultBlock = console.readLine(VaultLogger.ROOT_LOGGER.interactivePromptVaultBlock(), new Object[0]);
                    }
                    String attributeName = null;
                    while (attributeName == null || attributeName.length() == 0) {
                        attributeName = console.readLine(VaultLogger.ROOT_LOGGER.interactivePromptAttributeName(), new Object[0]);
                    }
                    try {
                        this.vaultNISession.addSecuredAttributeWithDisplay(vaultBlock, attributeName, attributeValue);
                    }
                    catch (Exception e) {
                        System.out.println(VaultLogger.ROOT_LOGGER.problemOcurred() + "\n" + e.getLocalizedMessage());
                    }
                    continue block11;
                }
                case 1: {
                    String attributeName;
                    String vaultBlock;
                    System.out.println(VaultLogger.ROOT_LOGGER.taskVerifySecuredAttributeExists());
                    try {
                        vaultBlock = null;
                        while (vaultBlock == null || vaultBlock.length() == 0) {
                            vaultBlock = console.readLine(VaultLogger.ROOT_LOGGER.interactivePromptVaultBlock(), new Object[0]);
                        }
                        attributeName = null;
                        while (attributeName == null || attributeName.length() == 0) {
                            attributeName = console.readLine(VaultLogger.ROOT_LOGGER.interactivePromptAttributeName(), new Object[0]);
                        }
                        if (!this.vaultNISession.checkSecuredAttribute(vaultBlock, attributeName)) {
                            System.out.println(VaultLogger.ROOT_LOGGER.interactiveMessageNoValueStored(VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName)));
                            break;
                        }
                        System.out.println(VaultLogger.ROOT_LOGGER.interactiveMessageValueStored(VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName)));
                    }
                    catch (Exception e) {
                        System.out.println(VaultLogger.ROOT_LOGGER.problemOcurred() + "\n" + e.getLocalizedMessage());
                    }
                    continue block11;
                }
                case 2: {
                    String attributeName;
                    String vaultBlock;
                    System.out.println(VaultLogger.ROOT_LOGGER.taskRemoveSecuredAttribute());
                    try {
                        vaultBlock = null;
                        while (vaultBlock == null || vaultBlock.length() == 0) {
                            vaultBlock = console.readLine(VaultLogger.ROOT_LOGGER.interactivePromptVaultBlock(), new Object[0]);
                        }
                        attributeName = null;
                        while (attributeName == null || attributeName.length() == 0) {
                            attributeName = console.readLine(VaultLogger.ROOT_LOGGER.interactivePromptAttributeName(), new Object[0]);
                        }
                        if (!this.vaultNISession.removeSecuredAttribute(vaultBlock, attributeName)) {
                            System.out.println(VaultLogger.ROOT_LOGGER.messageAttributeNotRemoved(VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName)));
                            break;
                        }
                        System.out.println(VaultLogger.ROOT_LOGGER.messageAttributeRemovedSuccessfuly(VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName)));
                    }
                    catch (Exception e) {
                        System.out.println(VaultLogger.ROOT_LOGGER.problemOcurred() + "\n" + e.getLocalizedMessage());
                    }
                    continue block11;
                }
                default: {
                    in.close();
                    System.exit(0);
                }
            }
        }
    }
}

