/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.jacc.SecurityActions;
import org.jboss.security.jacc.SubjectPolicyContextHandler;

public class SecurityService {
    private static final String JACC_POLICY_PROVIDER = "javax.security.jacc.policy.provider";
    private Policy oldPolicy;
    private Policy jaccPolicy;
    private ObjectName policyName;
    private String policyAttributeName = "Policy";
    private MBeanServer server;

    public ObjectName getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(ObjectName policyName) {
        this.policyName = policyName;
    }

    public String getPolicyAttributeName() {
        return this.policyAttributeName;
    }

    public void setPolicyAttributeName(String policyAttributeName) {
        this.policyAttributeName = policyAttributeName;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public Policy getPolicy() {
        return this.jaccPolicy;
    }

    public void setPolicy(Policy jaccPolicy) {
        this.jaccPolicy = jaccPolicy;
    }

    public void start() throws Exception {
        this.oldPolicy = Policy.getPolicy();
        if (this.server != null && this.policyName != null && this.server.isRegistered(this.policyName)) {
            try {
                this.jaccPolicy = (Policy)this.server.getAttribute(this.policyName, this.policyAttributeName);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugIgnoredException(e);
            }
        }
        if (this.jaccPolicy == null) {
            String provider = SecurityService.getProperty(JACC_POLICY_PROVIDER, "org.jboss.security.jacc.DelegatingPolicy");
            ClassLoader loader = SecurityActions.getContextClassLoader();
            Class<?> providerClass = loader.loadClass(provider);
            try {
                Class[] ctorSig = new Class[]{Policy.class};
                Constructor<?> ctor = providerClass.getConstructor(ctorSig);
                Object[] ctorArgs = new Object[]{this.oldPolicy};
                this.jaccPolicy = (Policy)ctor.newInstance(ctorArgs);
            }
            catch (NoSuchMethodException e) {
                this.jaccPolicy = (Policy)providerClass.newInstance();
            }
        }
        Policy.setPolicy(this.jaccPolicy);
        this.jaccPolicy.refresh();
        SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
        PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)handler, (boolean)true);
    }

    public void stop() throws Exception {
        if (this.jaccPolicy != null) {
            Policy.setPolicy(this.oldPolicy);
        }
    }

    static String getProperty(String name) {
        return SecurityService.getProperty(name, null);
    }

    static String getProperty(String name, String defaultValue) {
        PropertyAccessAction action = new PropertyAccessAction(name, defaultValue);
        String property = AccessController.doPrivileged(action);
        return property;
    }

    static class PropertyAccessAction
    implements PrivilegedAction<String> {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

