/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class UncheckedArrayList<T>
implements List<T> {
    private final Iterator<T> emptyIterator = new Iterator<T>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }
    };
    private T[] data;
    private int size;

    private UncheckedArrayList(Class<?> clazz, int capacity) {
        this.data = (Object[])Array.newInstance(clazz, capacity);
        this.size = 0;
    }

    public UncheckedArrayList(Class<?> clazz) {
        this(clazz, 4);
    }

    public UncheckedArrayList(Class<?> clazz, T[] initial) {
        this(clazz, initial.length);
        this.size = initial.length;
        System.arraycopy(initial, 0, this.data, 0, this.size);
    }

    @Override
    public boolean add(T element) {
        if (this.size >= this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length << 1);
        }
        this.data[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public T get(int index) {
        return this.data[index];
    }

    @Override
    public boolean remove(Object element) {
        for (int index = this.size - 1; index >= 0; --index) {
            if (element != this.data[index]) continue;
            int numMoved = this.size - index - 1;
            if (numMoved > 0) {
                System.arraycopy(this.data, index + 1, this.data, index, numMoved);
            }
            this.data[--this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public T set(int index, T element) {
        T old = this.data[index];
        this.data[index] = element;
        return old;
    }

    @Override
    public T remove(int index) {
        if (this.size == 0) {
            return null;
        }
        T old = this.data[index];
        int moved = this.size - index - 1;
        if (moved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, moved);
        }
        this.data[--this.size] = null;
        return old;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this.size == 0 ? this.emptyIterator : new UncheckedIterator<T>(this.data);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<T> stream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<T> parallelStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException();
    }

    private static final class UncheckedIterator<T>
    implements Iterator<T> {
        private final int size;
        private final T[] data;
        private int index = 0;

        public UncheckedIterator(T[] data) {
            this.data = data;
            this.size = data.length;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public T next() {
            if (this.index < this.size) {
                return this.data[this.index++];
            }
            throw new NoSuchElementException("No more elements in this list");
        }
    }
}

