/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.FilenameTabCompleter;

public class DefaultFilenameTabCompleter
extends FilenameTabCompleter {
    private static final EscapeSelector ESCAPE_SELECTOR = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == '\\' || ch == ' ' || ch == '\"';
        }
    };
    private static final EscapeSelector QUOTES_ONLY_ESCAPE_SELECTOR = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == '\"';
        }
    };

    public DefaultFilenameTabCompleter(CommandContext ctx) {
        super(ctx);
    }

    @Override
    void completeCandidates(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        boolean quoted = buffer.startsWith("\"");
        if (candidates.size() == 1) {
            EscapeSelector escSelector = quoted ? QUOTES_ONLY_ESCAPE_SELECTOR : ESCAPE_SELECTOR;
            candidates.set(0, Util.escapeString(candidates.get(0), escSelector));
        }
    }
}

