/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldStartCompletionService;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.processors.WeldDeploymentProcessor;
import org.jboss.as.weld.util.Utils;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class WeldDeploymentCleanupProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = Utils.getRootDeploymentUnit(deploymentUnit);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName weldStartCompletionServiceName = parent.getServiceName().append(WeldStartCompletionService.SERVICE_NAME);
        ServiceName weldBootstrapServiceName = parent.getServiceName().append(WeldBootstrapService.SERVICE_NAME);
        ServiceName weldStartServiceName = parent.getServiceName().append(WeldStartService.SERVICE_NAME);
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            return;
        }
        ServiceBuilder weldStartCompletionServiceBuilder = serviceTarget.addService(weldStartCompletionServiceName);
        Supplier bootstrapSupplier = weldStartCompletionServiceBuilder.requires(weldBootstrapServiceName);
        weldStartCompletionServiceBuilder.requires(weldStartServiceName);
        for (ServiceName componentStartSN : this.getComponentStartServiceNames(deploymentUnit)) {
            weldStartCompletionServiceBuilder.requires(componentStartSN);
        }
        List subDeployments = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.SUB_DEPLOYMENTS);
        for (DeploymentUnit sub : subDeployments) {
            ServiceRegistry registry = sub.getServiceRegistry();
            List<ServiceName> componentStartServiceNames = this.getComponentStartServiceNames(sub);
            for (ServiceName componentStartSN : componentStartServiceNames) {
                weldStartCompletionServiceBuilder.requires(componentStartSN);
            }
        }
        weldStartCompletionServiceBuilder.setInstance((Service)new WeldStartCompletionService(bootstrapSupplier, WeldDeploymentProcessor.getSetupActions(deploymentUnit), (ClassLoader)module.getClassLoader()));
        weldStartCompletionServiceBuilder.install();
    }

    public void undeploy(DeploymentUnit context) {
    }

    private List<ServiceName> getComponentStartServiceNames(DeploymentUnit deploymentUnit) {
        ArrayList<ServiceName> serviceNames = new ArrayList<ServiceName>();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (eeModuleDescription == null) {
            return serviceNames;
        }
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            serviceNames.add(component.getStartServiceName());
        }
        return serviceNames;
    }
}

