/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry {
    private final ObfuscatedTracerProvider tracerProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(ObfuscatedTracerProvider tracerProvider, ContextPropagators propagators) {
        this.tracerProvider = tracerProvider;
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        public Tracer get(String instrumentationName) {
            return this.delegate.get(instrumentationName);
        }

        public Tracer get(String instrumentationName, String instrumentationVersion) {
            return this.delegate.get(instrumentationName, instrumentationVersion);
        }

        public TracerBuilder tracerBuilder(String instrumentationName) {
            return this.delegate.tracerBuilder(instrumentationName);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

