/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IracStateResponseCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 120;
    private ByteString cacheName;
    private int segment;
    private Object key;
    private Object lockOwner;
    private IracMetadata tombstone;

    public IracStateResponseCommand() {
    }

    public IracStateResponseCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracStateResponseCommand(ByteString cacheName, int segment, Object key, Object lockOwner, IracMetadata tombstone) {
        this(cacheName);
        this.segment = segment;
        this.key = key;
        this.lockOwner = lockOwner;
        this.tombstone = tombstone;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        registry.getIracManager().wired().receiveState(this.segment, this.key, this.lockOwner, this.tombstone);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 120;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeInt(this.segment);
        output.writeObject(this.key);
        boolean cId = this.lockOwner instanceof CommandInvocationId;
        output.writeBoolean(cId);
        if (cId) {
            CommandInvocationId.writeTo(output, (CommandInvocationId)this.lockOwner);
        } else {
            output.writeObject(this.lockOwner);
        }
        boolean nullTombstone = this.tombstone == null;
        output.writeBoolean(nullTombstone);
        if (!nullTombstone) {
            this.tombstone.writeTo(output);
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.segment = input.readInt();
        this.key = input.readObject();
        this.lockOwner = input.readBoolean() ? CommandInvocationId.readFrom(input) : input.readObject();
        this.tombstone = input.readBoolean() ? null : IracMetadata.readFrom(input);
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracStateResponseCommand{cacheName=" + this.cacheName + ", key=" + this.key + ", lockOwner=" + this.lockOwner + ", tombstone=" + this.tombstone + '}';
    }
}

