/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.factories;

import java.net.InetAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.security.xacml.core.model.context.AttributeType;
import org.jboss.security.xacml.core.model.context.AttributeValueType;

public class RequestAttributeFactory {
    public static AttributeType createAnyURIAttributeType(String attrID, String issuer, URI value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, "" + value, "http://www.w3.org/2001/XMLSchema#anyURI");
    }

    public static AttributeType createBase64BinaryAttributeType(String attrID, String issuer, byte[] value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value, "http://www.w3.org/2001/XMLSchema#base64Binary");
    }

    public static AttributeType createBooleanAttributeType(String attrID, String issuer, boolean value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value, "http://www.w3.org/2001/XMLSchema#boolean");
    }

    public static AttributeType createDateAttributeType(String attrID, String issuer) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, RequestAttributeFactory.getXMLDate(), "http://www.w3.org/2001/XMLSchema#date");
    }

    public static AttributeType createDateAttributeType(String attrID, String issuer, XMLGregorianCalendar value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value.toXMLFormat(), "http://www.w3.org/2001/XMLSchema#date");
    }

    public static AttributeType createDateTimeAttributeType(String attrID, String issuer) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, RequestAttributeFactory.getXMLDateTime(), "http://www.w3.org/2001/XMLSchema#dateTime");
    }

    public static AttributeType createDateTimeAttributeType(String attrID, String issuer, XMLGregorianCalendar value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value.toXMLFormat(), "http://www.w3.org/2001/XMLSchema#dateTime");
    }

    public static AttributeType createDNSNameAttributeType(String attrID, String issuer, String hostname) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, hostname, "urn:oasis:names:tc:xacml:2.0:data-type:dnsName");
    }

    public static AttributeType createDoubleAttributeType(String attrID, String issuer, double value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, "" + value, "http://www.w3.org/2001/XMLSchema#double");
    }

    public static AttributeType createEmailAttributeType(String attrID, String issuer, String value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value, "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name");
    }

    public static AttributeType createHexBinaryAttributeType(String attrID, String issuer, byte[] value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value, "http://www.w3.org/2001/XMLSchema#hexBinary");
    }

    public static AttributeType createIntegerAttributeType(String attrID, String issuer, int value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, "" + value, "http://www.w3.org/2001/XMLSchema#integer");
    }

    public static AttributeType createIPAddressAttributeType(String attrID, String issuer, InetAddress address) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, address, "urn:oasis:names:tc:xacml:2.0:data-type:ipAddress");
    }

    public static AttributeType createStringAttributeType(String attrID, String issuer, String value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value, "http://www.w3.org/2001/XMLSchema#string");
    }

    public static AttributeType createTimeAttributeType(String attrID, String issuer) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, RequestAttributeFactory.getXMLTime(), "http://www.w3.org/2001/XMLSchema#time");
    }

    public static AttributeType createTimeAttributeType(String attrID, String issuer, XMLGregorianCalendar value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value.toXMLFormat(), "http://www.w3.org/2001/XMLSchema#time");
    }

    public static AttributeType createX509NameAttributeType(String attrID, String issuer, X500Principal value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value, "urn:oasis:names:tc:xacml:1.0:data-type:x500Name");
    }

    public static AttributeType createDayTimeDurationAttributeType(String attrID, String issuer, Duration value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value.toString(), "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration");
    }

    public static AttributeType createYearMonthDurationAttributeType(String attrID, String issuer, Duration value) {
        return RequestAttributeFactory.getBareAttributeType(attrID, issuer, value.toString(), "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration");
    }

    public static AttributeType createMultiValuedAttributeType(String attrID, String issuer, String dataType, String[] values) {
        AttributeType attributeType = new AttributeType();
        attributeType.setAttributeId(attrID);
        attributeType.setDataType(dataType);
        if (issuer != null) {
            attributeType.setIssuer(issuer);
        }
        List<String> valueList = Arrays.asList(values);
        AttributeValueType avt = new AttributeValueType();
        avt.getContent().addAll(valueList);
        attributeType.getAttributeValue().add(avt);
        return attributeType;
    }

    private static AttributeType getBareAttributeType(String attrID, String issuer, Object value, String dataType) {
        AttributeType attributeType = new AttributeType();
        attributeType.setAttributeId(attrID);
        attributeType.setDataType(dataType);
        if (issuer != null) {
            attributeType.setIssuer(issuer);
        }
        AttributeValueType avt = new AttributeValueType();
        avt.getContent().add(value);
        attributeType.getAttributeValue().add(avt);
        return attributeType;
    }

    private static String getXMLDateTime() {
        DatatypeFactory dtf;
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        XMLGregorianCalendar value = dtf.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        return value.toXMLFormat();
    }

    private static String getXMLDate() {
        DatatypeFactory dtf;
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        XMLGregorianCalendar value = dtf.newXMLGregorianCalendarDate(cal.get(1), cal.get(2), cal.get(5), cal.getTimeZone().getRawOffset() / 60000);
        return value.toXMLFormat();
    }

    private static String getXMLTime() {
        DatatypeFactory dtf;
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        XMLGregorianCalendar value = dtf.newXMLGregorianCalendarTime(cal.get(10), cal.get(12), cal.get(13), cal.get(14), cal.getTimeZone().getRawOffset() / 60000);
        return value.toXMLFormat();
    }
}

