/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.RemoteMetadata;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.scattered.ScatteredVersionManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingKeyCacheSet;
import org.infinispan.util.concurrent.CompletableFutures;

public class PrefetchInterceptor<K, V>
extends DDAsyncInterceptor {
    protected static final Log log = LogFactory.getLog(PrefetchInterceptor.class);
    protected static final long STATE_TRANSFER_FLAGS = FlagBitSets.PUT_FOR_STATE_TRANSFER | FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.IGNORE_RETURN_VALUES | FlagBitSets.SKIP_REMOTE_LOOKUP | FlagBitSets.SKIP_SHARED_CACHE_STORE | FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.SKIP_XSITE_BACKUP;
    @Inject
    protected ScatteredVersionManager svm;
    @Inject
    protected DistributionManager dm;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    protected CommandsFactory commandsFactory;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected ComponentRef<AdvancedCache<K, V>> cache;
    @Inject
    protected EntryFactory entryFactory;
    @Inject
    protected InternalDataContainer dataContainer;
    protected int numSegments;
    private final InvocationSuccessFunction handleRemotelyPrefetchedEntry = this::handleRemotelyPrefetchedEntry;

    @Start
    public void start() {
        this.numSegments = this.cacheConfiguration.clustering().hash().numSegments();
    }

    private boolean canRetrieveRemoteValue(FlagAffectedCommand command) {
        return !command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK);
    }

    protected Object handleReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntry(command.getKey());
        }
        if (this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeyIfNeededAndInvokeNext(ctx, command, command.getKey(), false);
        }
        return this.invokeNext(ctx, command);
    }

    private Object prefetchKeyIfNeededAndInvokeNext(InvocationContext ctx, DataCommand command, Object key, boolean isWrite) {
        int segment = command.getSegment();
        switch (this.svm.getSegmentState(segment)) {
            case NOT_OWNED: {
                break;
            }
            case BLOCKED: {
                if (isWrite) {
                    return PrefetchInterceptor.asyncValue(this.svm.getBlockingFuture(segment)).thenApply(ctx, command, (rCtx, rCommand, ignored) -> this.prefetchKeyIfNeededAndInvokeNext(ctx, command, key, true));
                }
            }
            case KEY_TRANSFER: 
            case VALUE_TRANSFER: {
                InvocationStage nextStage = this.lookupLocalAndRetrieveRemote(ctx, key, command, segment);
                if (nextStage == null) break;
                return this.asyncInvokeNext(ctx, (VisitableCommand)command, nextStage);
            }
            case OWNED: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends VisitableCommand & TopologyAffectedCommand> Object prefetchKeysIfNeededAndInvokeNext(InvocationContext ctx, C command, Collection<?> keys, boolean isWrite) {
        BitSet blockedSegments = null;
        ArrayList transferedKeys = null;
        block6: for (Object key : keys) {
            int segment = this.keyPartitioner.getSegment(key);
            switch (this.svm.getSegmentState(segment)) {
                case NOT_OWNED: {
                    continue block6;
                }
                case BLOCKED: {
                    if (isWrite) {
                        if (blockedSegments == null) {
                            blockedSegments = new BitSet(this.numSegments);
                        }
                        blockedSegments.set(segment);
                    }
                }
                case KEY_TRANSFER: 
                case VALUE_TRANSFER: {
                    if (transferedKeys == null) {
                        transferedKeys = new ArrayList(keys.size());
                    }
                    transferedKeys.add(key);
                }
                case OWNED: {
                    continue block6;
                }
            }
            throw new IllegalStateException();
        }
        if (blockedSegments != null) {
            CompletableFuture<Void> blockingFuture = CompletableFuture.allOf((CompletableFuture[])blockedSegments.stream().mapToObj(this.svm::getBlockingFuture).toArray(CompletableFuture[]::new));
            return PrefetchInterceptor.asyncValue(blockingFuture).thenApply(ctx, command, (rCtx, rCommand, rv) -> this.prefetchKeysIfNeededAndInvokeNext(rCtx, rCommand, keys, true));
        }
        if (transferedKeys != null) {
            return this.asyncInvokeNext(ctx, command, this.retrieveRemoteValues(ctx, command, transferedKeys));
        }
        return this.invokeNext(ctx, command);
    }

    private InvocationStage lookupLocalAndRetrieveRemote(InvocationContext ctx, Object key, DataCommand cmd, int segment) {
        Metadata metadata;
        InternalCacheEntry entry = this.dataContainer.get(segment, key);
        if (log.isTraceEnabled()) {
            log.tracef("Locally prefetched entry %s", entry);
        }
        Metadata metadata2 = metadata = entry != null ? entry.getMetadata() : null;
        if (metadata != null && metadata.version() != null && this.svm.isVersionActual(segment, metadata.version())) {
            this.entryFactory.wrapExternalEntry(ctx, key, entry, true, true);
            return null;
        }
        if (metadata instanceof RemoteMetadata && this.svm.getSegmentState(segment) == ScatteredVersionManager.SegmentState.VALUE_TRANSFER) {
            Address backup = ((RemoteMetadata)metadata).getAddress();
            return this.retrieveRemoteValue(ctx, Collections.singleton(backup), key, segment, cmd);
        }
        return this.retrieveRemoteValue(ctx, null, key, segment, cmd);
    }

    private InvocationStage retrieveRemoteValue(InvocationContext ctx, Collection<Address> targets, Object key, int segment, DataCommand dataCommand) {
        if (log.isTraceEnabled()) {
            log.tracef("Prefetching entry for key %s from %s", key, targets);
        }
        ClusteredGetCommand command = this.commandsFactory.buildClusteredGetCommand(key, segment, FlagBitSets.SKIP_OWNERSHIP_CHECK);
        command.setTopologyId(dataCommand.getTopologyId());
        CompletionStage<Map<Address, Response>> remoteInvocation = targets != null ? this.rpcManager.invokeCommand(targets, (ReplicableCommand)command, MapResponseCollector.ignoreLeavers(targets.size()), this.rpcManager.getSyncRpcOptions()) : this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        return PrefetchInterceptor.asyncValue(remoteInvocation).thenApplyMakeStage(ctx, dataCommand, this.handleRemotelyPrefetchedEntry);
    }

    private Object handleRemotelyPrefetchedEntry(InvocationContext ctx, VisitableCommand command, Object rv) {
        Map responseMap = (Map)rv;
        EntryVersion maxVersion = null;
        InternalCacheValue maxValue = null;
        for (Response response : responseMap.values()) {
            if (!response.isSuccessful()) {
                throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
            }
            SuccessfulResponse successfulResponse = (SuccessfulResponse)response;
            InternalCacheValue icv = (InternalCacheValue)successfulResponse.getResponseValue();
            if (icv == null) continue;
            Metadata metadata = icv.getMetadata();
            if (metadata instanceof RemoteMetadata) {
                throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
            }
            if (metadata == null || metadata.version() == null || maxVersion != null && maxVersion.compareTo(metadata.version()) != InequalVersionComparisonResult.BEFORE) continue;
            maxVersion = metadata.version();
            maxValue = icv;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Prefetched value is %s", maxValue);
        }
        DataCommand dataCommand = (DataCommand)command;
        if (maxValue == null) {
            return null;
        }
        this.entryFactory.wrapExternalEntry(ctx, dataCommand.getKey(), maxValue.toInternalCacheEntry(dataCommand.getKey()), true, true);
        PutKeyValueCommand putKeyValueCommand = this.commandsFactory.buildPutKeyValueCommand(dataCommand.getKey(), maxValue.getValue(), dataCommand.getSegment(), new InternalMetadataImpl(maxValue), STATE_TRANSFER_FLAGS);
        putKeyValueCommand.setTopologyId(dataCommand.getTopologyId());
        return this.invokeNext(ctx, putKeyValueCommand);
    }

    private <C extends VisitableCommand & TopologyAffectedCommand> InvocationStage retrieveRemoteValues(InvocationContext ctx, C originCommand, List<?> keys) {
        if (log.isTraceEnabled()) {
            log.tracef("Prefetching entries for keys %s using broadcast", keys);
        }
        ClusteredGetAllCommand command = this.commandsFactory.buildClusteredGetAllCommand(keys, FlagBitSets.SKIP_OWNERSHIP_CHECK, null);
        command.setTopologyId(((TopologyAffectedCommand)originCommand).getTopologyId());
        CompletionStage<Map<Address, Response>> rpcFuture = this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
        return PrefetchInterceptor.asyncValue(rpcFuture).thenApplyMakeStage(ctx, originCommand, (rCtx, topologyAffectedCommand, rv) -> {
            Map responseMap = (Map)rv;
            InternalCacheValue[] maxValues = new InternalCacheValue[keys.size()];
            for (Response response : responseMap.values()) {
                if (!response.isSuccessful()) {
                    throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
                }
                InternalCacheValue[] values = (InternalCacheValue[])((SuccessfulResponse)response).getResponseValue();
                int i = 0;
                for (InternalCacheValue icv : values) {
                    if (icv != null) {
                        Metadata maxMetadata;
                        Metadata metadata = icv.getMetadata();
                        if (metadata instanceof RemoteMetadata) {
                            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
                        }
                        if (maxValues[i] == null) {
                            maxValues[i] = icv;
                        } else if (metadata != null && metadata.version() != null && ((maxMetadata = maxValues[i].getMetadata()) == null || maxMetadata.version() == null || maxMetadata.version().compareTo(metadata.version()) == InequalVersionComparisonResult.BEFORE)) {
                            maxValues[i] = icv;
                        }
                    }
                    ++i;
                }
            }
            HashMap map = new HashMap(keys.size());
            for (int i = 0; i < maxValues.length; ++i) {
                if (maxValues[i] == null) continue;
                map.put(keys.get(i), maxValues[i]);
            }
            if (log.isTraceEnabled()) {
                log.tracef("Prefetched values are %s", map);
            }
            if (map.isEmpty()) {
                return CompletableFutures.completedNull();
            }
            for (Map.Entry entry : map.entrySet()) {
                this.entryFactory.wrapExternalEntry(rCtx, entry.getKey(), ((InternalCacheValue)entry.getValue()).toInternalCacheEntry(entry.getKey()), true, true);
            }
            PutMapCommand putMapCommand = this.commandsFactory.buildPutMapCommand(map, null, STATE_TRANSFER_FLAGS);
            putMapCommand.setTopologyId(((TopologyAffectedCommand)((Object)topologyAffectedCommand)).getTopologyId());
            return this.invokeNext(rCtx, putMapCommand);
        });
    }

    protected Object handleReadManyCommand(InvocationContext ctx, AbstractTopologyAffectedCommand command, Collection<?> keys) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntries(keys);
        }
        if (this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeysIfNeededAndInvokeNext(ctx, command, keys, false);
        }
        return this.invokeNext(ctx, command);
    }

    protected Object handleWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntry(command.getKey());
        }
        if (command.loadType() != VisitableCommand.LoadType.DONT_LOAD && this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeyIfNeededAndInvokeNext(ctx, command, command.getKey(), true);
        }
        return this.invokeNext(ctx, command);
    }

    protected Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            ctx.removeLookedUpEntries(command.getAffectedKeys());
        }
        if (command.loadType() != VisitableCommand.LoadType.DONT_LOAD && this.canRetrieveRemoteValue(command)) {
            return this.prefetchKeysIfNeededAndInvokeNext(ctx, command, command.getAffectedKeys(), true);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.handleReadManyCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        return this.handleReadCommand(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        return this.handleReadManyCommand(ctx, command, command.getKeys());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleWriteManyCommand(ctx, command);
    }

    public AdvancedCache getCacheWithFlags(FlagAffectedCommand command) {
        Set<Flag> flags = command.getFlags();
        return this.cache.wired().withFlags(flags.toArray(new Flag[flags.size()]));
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            boolean ignoreOwnership = rCommand.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK);
            return new BackingKeySet(ignoreOwnership, (CacheSet)rv);
        });
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            boolean ignoreOwnership = rCommand.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK);
            return new BackingEntrySet(ignoreOwnership, (CacheSet)rv);
        });
    }

    @Override
    public Object visitGetKeysInGroupCommand(InvocationContext ctx, GetKeysInGroupCommand command) throws Throwable {
        if (command.isGroupOwner()) {
            int segment = this.keyPartitioner.getSegment(command.getGroupName());
            switch (this.svm.getSegmentState(segment)) {
                case NOT_OWNED: {
                    break;
                }
                case BLOCKED: 
                case KEY_TRANSFER: 
                case VALUE_TRANSFER: {
                    return this.asyncInvokeNext(ctx, (VisitableCommand)command, this.svm.valuesFuture(command.getTopologyId()));
                }
                case OWNED: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this.invokeNext(ctx, command);
    }

    private class BackingKeySet
    extends AbstractDelegatingKeyCacheSet<K, V>
    implements CacheSet<K> {
        private final boolean ignoreOwnership;

        public BackingKeySet(boolean ignoreOwnership, CacheSet<K> keySet) {
            super(PrefetchInterceptor.this.cache.wired(), keySet);
            this.ignoreOwnership = ignoreOwnership;
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new BackingIterator(PrefetchInterceptor.this.cache.wired(), this.ignoreOwnership, () -> ((CacheSet)this.delegate()).iterator(), Function.identity());
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
        }
    }

    private class BackingIterator<O, K, V>
    implements CloseableIterator<O> {
        private final Cache<K, V> cache;
        private final Supplier<Iterator<O>> supplier;
        private final Function<O, K> keyRetrieval;
        private final boolean ignoreOwnership;
        private Iterator<O> iterator;
        private K previousKey;
        private O next;
        private List<Integer> blockedSegments;
        private int lastTopology;
        private boolean[] finishedSegments;

        public void remove() {
            if (this.previousKey == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(this.previousKey);
            this.previousKey = null;
        }

        public BackingIterator(Cache<K, V> cache, boolean ignoreOwnership, Supplier<Iterator<O>> supplier, Function<O, K> keyRetrieval) {
            this.cache = cache;
            this.ignoreOwnership = ignoreOwnership;
            this.supplier = supplier;
            log.tracef("Retrieving iterator for %s for the first time", cache);
            this.iterator = supplier.get();
            this.keyRetrieval = keyRetrieval;
            this.findNotReadySegments();
        }

        protected void findNotReadySegments() {
            if (this.ignoreOwnership) {
                return;
            }
            do {
                this.lastTopology = PrefetchInterceptor.this.dm.getCacheTopology().getTopologyId();
                int numSegments = this.cache.getCacheConfiguration().clustering().hash().numSegments();
                if (this.blockedSegments != null) {
                    this.blockedSegments.clear();
                }
                block5: for (int segment = 0; segment < numSegments; ++segment) {
                    switch (PrefetchInterceptor.this.svm.getSegmentState(segment)) {
                        case NOT_OWNED: {
                            continue block5;
                        }
                        case BLOCKED: 
                        case KEY_TRANSFER: 
                        case VALUE_TRANSFER: {
                            this.addBlocked(segment);
                            continue block5;
                        }
                    }
                }
            } while (PrefetchInterceptor.this.dm.getCacheTopology().getTopologyId() != this.lastTopology);
        }

        private void addBlocked(int segment) {
            if (this.blockedSegments == null) {
                this.blockedSegments = new ArrayList<Integer>();
            }
            this.blockedSegments.add(segment);
        }

        public boolean hasNext() {
            if (this.iterator == null) {
                this.next = null;
                return false;
            }
            while (true) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (this.ignoreOwnership) {
                        return true;
                    }
                    int segment = PrefetchInterceptor.this.keyPartitioner.getSegment(this.keyRetrieval.apply(this.next));
                    if (this.finishedSegments != null && this.finishedSegments[segment] || PrefetchInterceptor.this.svm.getSegmentState(segment) != ScatteredVersionManager.SegmentState.OWNED) continue;
                    return true;
                }
                if (this.blockedSegments == null || this.blockedSegments.isEmpty()) break;
                if (this.lastTopology == PrefetchInterceptor.this.dm.getCacheTopology().getTopologyId()) {
                    int numSegments = this.cache.getCacheConfiguration().clustering().hash().numSegments();
                    boolean[] newFinishedSegments = this.finishedSegments == null ? new boolean[numSegments] : Arrays.copyOf(this.finishedSegments, numSegments);
                    for (int segment = 0; segment < numSegments; ++segment) {
                        if (PrefetchInterceptor.this.svm.getSegmentState(segment) != ScatteredVersionManager.SegmentState.OWNED) continue;
                        newFinishedSegments[segment] = true;
                    }
                    if (this.lastTopology == PrefetchInterceptor.this.dm.getCacheTopology().getTopologyId()) {
                        this.finishedSegments = newFinishedSegments;
                    }
                }
                try {
                    PrefetchInterceptor.this.svm.valuesFuture(this.lastTopology).get(PrefetchInterceptor.this.cacheConfiguration.clustering().stateTransfer().timeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw new CacheException((Throwable)e);
                }
                this.findNotReadySegments();
                if (this.iterator instanceof CloseableIterator) {
                    ((CloseableIterator)this.iterator).close();
                }
                log.tracef("Retrieving iterator for %s in topology %d, blocked segments are %s", this.cache, (Object)this.lastTopology, this.blockedSegments);
                this.iterator = this.supplier.get();
            }
            return false;
        }

        public O next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.next != null);
            this.previousKey = this.keyRetrieval.apply(this.next);
            return this.next;
        }

        public void close() {
            if (this.iterator instanceof CloseableIterator) {
                ((CloseableIterator)this.iterator).close();
            }
            this.iterator = null;
        }
    }

    private class BackingEntrySet
    extends AbstractDelegatingEntryCacheSet<K, V>
    implements CacheSet<CacheEntry<K, V>> {
        private final CacheSet<CacheEntry<K, V>> entrySet;
        private final boolean ignoreOwnership;

        public BackingEntrySet(boolean ignoreOwnership, CacheSet<CacheEntry<K, V>> entrySet) {
            super(PrefetchInterceptor.this.cache.wired(), entrySet);
            this.ignoreOwnership = ignoreOwnership;
            this.entrySet = entrySet;
        }

        @Override
        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return new BackingIterator(PrefetchInterceptor.this.cache.wired(), this.ignoreOwnership, () -> this.entrySet.stream().iterator(), Map.Entry::getKey);
        }

        @Override
        public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
        }
    }
}

