/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.ToIntFunction;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.BasicMirrorController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.MirrorTransaction;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceNodeStore;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.pools.MpscPool;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.jboss.logging.Logger;

public class AMQPMirrorControllerTarget
extends ProtonAbstractReceiver
implements MirrorController {
    private static final Logger logger = Logger.getLogger(AMQPMirrorControllerTarget.class);
    private static ThreadLocal<MirrorController> controllerThreadLocal = new ThreadLocal();
    private final MpscPool<ACKMessageOperation> ackMessageMpscPool;
    final RoutingContextImpl routingContext;
    final BasicMirrorController<Receiver> basicController;
    final ActiveMQServer server;
    DuplicateIDCache lruduplicateIDCache;
    String lruDuplicateIDKey;
    private final ReferenceNodeStore referenceNodeStore;

    public static void setControllerInUse(MirrorController controller) {
        controllerThreadLocal.set(controller);
    }

    public static MirrorController getControllerInUse() {
        return controllerThreadLocal.get();
    }

    public AMQPMirrorControllerTarget(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver, ActiveMQServer server) {
        super(sessionSPI, connection, protonSession, receiver);
        this.ackMessageMpscPool = new MpscPool(this.amqpCredits, ACKMessageOperation::reset, () -> new ACKMessageOperation());
        this.routingContext = new RoutingContextImpl(null);
        this.basicController = new BasicMirrorController(server);
        this.basicController.setLink(receiver);
        this.server = server;
        this.referenceNodeStore = sessionSPI.getProtocolManager().getReferenceIDSupplier();
    }

    public String getRemoteMirrorId() {
        return this.basicController.getRemoteMirrorId();
    }

    @Override
    public void flow() {
        this.creditRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualDelivery(AMQPMessage message, Delivery delivery, Receiver receiver, Transaction tx) {
        this.recoverContext();
        this.incrementSettle();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.server + "::actualdelivery call for " + (Object)((Object)message)));
        }
        AMQPMirrorControllerTarget.setControllerInUse(this);
        delivery.setContext((Object)message);
        ACKMessageOperation messageAckOperation = ((ACKMessageOperation)this.ackMessageMpscPool.borrow()).setDelivery(delivery);
        try {
            Object eventType = AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.EVENT_TYPE);
            if (eventType != null) {
                if (eventType.equals(AMQPMirrorControllerSource.ADD_ADDRESS)) {
                    AddressInfo addressInfo = this.parseAddress(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.server + " Adding Address " + addressInfo));
                    }
                    this.addAddress(addressInfo);
                } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_ADDRESS)) {
                    AddressInfo addressInfo = this.parseAddress(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.server + " Removing Address " + addressInfo));
                    }
                    this.deleteAddress(addressInfo);
                } else if (eventType.equals(AMQPMirrorControllerSource.CREATE_QUEUE)) {
                    QueueConfiguration queueConfiguration = this.parseQueue(message);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.server + " Creating queue " + queueConfiguration));
                    }
                    this.createQueue(queueConfiguration);
                } else if (eventType.equals(AMQPMirrorControllerSource.DELETE_QUEUE)) {
                    String address = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.ADDRESS);
                    String queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.QUEUE);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.server + " Deleting queue " + queueName + " on address " + address));
                    }
                    this.deleteQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName));
                } else if (eventType.equals(AMQPMirrorControllerSource.POST_ACK)) {
                    String address = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.ADDRESS);
                    String nodeID = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.BROKER_ID);
                    if (nodeID == null) {
                        nodeID = this.getRemoteMirrorId();
                    }
                    String queueName = (String)AMQPMessageBrokerAccessor.getMessageAnnotationProperty(message, AMQPMirrorControllerSource.QUEUE);
                    AmqpValue value = (AmqpValue)message.getBody();
                    Long messageID = (Long)value.getValue();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.server + " Post ack address=" + address + " queueName = " + queueName + " messageID=" + messageID + ", nodeID=" + nodeID));
                    }
                    if (this.postAcknowledge(address, queueName, nodeID, messageID, messageAckOperation)) {
                        messageAckOperation = null;
                    }
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.server + " Sending message " + (Object)((Object)message)));
                }
                if (this.sendMessage(message, messageAckOperation)) {
                    messageAckOperation = null;
                }
            }
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
        }
        finally {
            AMQPMirrorControllerTarget.setControllerInUse(null);
            if (messageAckOperation != null) {
                this.server.getStorageManager().afterCompleteOperations((IOCallback)messageAckOperation);
            }
        }
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        Target target = (Target)this.receiver.getRemoteTarget();
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        this.flow();
    }

    private QueueConfiguration parseQueue(AMQPMessage message) throws Exception {
        AmqpValue bodyvalue = (AmqpValue)message.getBody();
        String body = (String)bodyvalue.getValue();
        QueueConfiguration queueConfiguration = QueueConfiguration.fromJSON((String)body);
        return queueConfiguration;
    }

    private AddressInfo parseAddress(AMQPMessage message) throws Exception {
        AmqpValue bodyvalue = (AmqpValue)message.getBody();
        String body = (String)bodyvalue.getValue();
        AddressInfo addressInfo = AddressInfo.fromJSON((String)body);
        return addressInfo;
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.server + " Adding address " + addressInfo));
        }
        this.server.addAddressInfo(addressInfo);
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.server + " delete address " + addressInfo));
        }
        try {
            this.server.removeAddressInfo(addressInfo.getName(), null, true);
        }
        catch (ActiveMQAddressDoesNotExistException expected) {
            logger.debug((Object)expected.getMessage(), (Throwable)expected);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.server + " Adding queue " + queueConfiguration));
        }
        try {
            this.server.createQueue(queueConfiguration, true);
        }
        catch (Exception ignored) {
            logger.debug((Object)("Queue could not be created, already existed " + queueConfiguration), (Throwable)ignored);
        }
    }

    public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.server + " destroy queue " + queueName + " on address = " + addressName + " server " + this.server.getIdentity()));
        }
        try {
            this.server.destroyQueue(queueName, null, false, true, false, false);
        }
        catch (ActiveMQNonExistentQueueException expected) {
            logger.debug((Object)(this.server + " queue " + queueName + " was previously removed"), (Throwable)expected);
        }
    }

    public boolean postAcknowledge(String address, String queue, String nodeID, long messageID, ACKMessageOperation ackMessage) throws Exception {
        Queue targetQueue = this.server.locateQueue(queue);
        if (targetQueue == null) {
            logger.warn((Object)("Queue " + queue + " not found on mirror target, ignoring ack for queue=" + queue + ", messageID=" + messageID + ", nodeID=" + nodeID));
            return false;
        }
        if (logger.isDebugEnabled() && targetQueue.getConsumerCount() > 0) {
            logger.debug((Object)("server " + this.server.getIdentity() + ", queue " + targetQueue.getName() + " has consumers while delivering ack for " + messageID));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Server " + this.server.getIdentity() + " with queue = " + queue + " being acked for " + messageID + " coming from " + messageID + " targetQueue = " + targetQueue));
        }
        this.performAck(nodeID, messageID, targetQueue, ackMessage, true);
        return true;
    }

    public void performAckOnPage(String nodeID, long messageID, Queue targetQueue, IOCallback ackMessageOperation) {
        PageAck pageAck = new PageAck(targetQueue, nodeID, messageID, ackMessageOperation);
        targetQueue.getPageSubscription().scanAck((BooleanSupplier)pageAck, (ToIntFunction)pageAck, (Runnable)pageAck, (Runnable)pageAck);
    }

    private void performAck(String nodeID, long messageID, Queue targetQueue, ACKMessageOperation ackMessageOperation, boolean retry) {
        MessageReference reference;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("performAck (nodeID=" + nodeID + ", messageID=" + messageID + "), targetQueue=" + targetQueue.getName()));
        }
        if ((reference = targetQueue.removeWithSuppliedID(nodeID, messageID, (NodeStore)this.referenceNodeStore)) == null && retry) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrying Reference not found on messageID=" + messageID + " nodeID=" + nodeID));
            }
            targetQueue.flushOnIntermediate(() -> {
                this.recoverContext();
                this.performAck(nodeID, messageID, targetQueue, ackMessageOperation, false);
            });
            return;
        }
        if (reference != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Post ack Server " + this.server + " worked well for messageID=" + messageID + " nodeID=" + nodeID));
            }
            try {
                targetQueue.acknowledge(reference);
                OperationContextImpl.getContext().executeOnCompletion((IOCallback)ackMessageOperation);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            this.performAckOnPage(nodeID, messageID, targetQueue, ackMessageOperation);
        }
    }

    private boolean sendMessage(AMQPMessage message, ACKMessageOperation messageCompletionAck) throws Exception {
        DuplicateIDCache duplicateIDCache;
        String internalMirrorID;
        if (message.getMessageID() <= 0L) {
            message.setMessageID(this.server.getStorageManager().generateID());
        }
        if ((internalMirrorID = (String)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.BROKER_ID)) == null) {
            internalMirrorID = this.getRemoteMirrorId();
        }
        Long internalIDLong = (Long)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.INTERNAL_ID);
        String internalAddress = (String)AMQPMessageBrokerAccessor.getDeliveryAnnotationProperty(message, AMQPMirrorControllerSource.INTERNAL_DESTINATION);
        long internalID = 0L;
        if (internalIDLong != null) {
            internalID = internalIDLong;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("sendMessage on server " + this.server + " for message " + (Object)((Object)message) + " with internalID = " + internalIDLong + " mirror id " + internalMirrorID));
        }
        this.routingContext.setDuplicateDetection(false);
        if (this.lruDuplicateIDKey != null && this.lruDuplicateIDKey.equals(internalMirrorID)) {
            duplicateIDCache = this.lruduplicateIDCache;
        } else {
            if (logger.isDebugEnabled()) {
                logger.trace((Object)("Setting up duplicate detection cache on $ACTIVEMQ_ARTEMIS_MIRROR, ServerID=" + internalMirrorID + " with " + this.connection.getAmqpCredits() + " elements, being the number of credits"));
            }
            this.lruDuplicateIDKey = internalMirrorID;
            duplicateIDCache = this.lruduplicateIDCache = this.server.getPostOffice().getDuplicateIDCache(SimpleString.toSimpleString((String)("$ACTIVEMQ_ARTEMIS_MIRROR_" + internalMirrorID)), this.connection.getAmqpCredits());
        }
        byte[] duplicateIDBytes = ByteUtil.longToBytes((long)internalIDLong);
        if (duplicateIDCache.contains(duplicateIDBytes)) {
            this.flow();
            return false;
        }
        message.setBrokerProperty(AMQPMirrorControllerSource.INTERNAL_ID_EXTRA_PROPERTY, internalID);
        message.setBrokerProperty(AMQPMirrorControllerSource.INTERNAL_BROKER_ID_EXTRA_PROPERTY, internalMirrorID);
        if (internalAddress != null) {
            message.setAddress(internalAddress);
        }
        MirrorTransaction transaction = new MirrorTransaction(this.server.getStorageManager());
        transaction.addOperation((TransactionOperation)messageCompletionAck.tx);
        this.routingContext.setTransaction((Transaction)transaction);
        duplicateIDCache.addToCache(duplicateIDBytes, (Transaction)transaction);
        this.routingContext.clear().setMirrorSource((MirrorController)this);
        this.server.getPostOffice().route((Message)message, (RoutingContext)this.routingContext, false);
        transaction.commit();
        this.flow();
        return true;
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) {
    }

    public void sendMessage(Message message, RoutingContext context, List<MessageReference> refs) {
    }

    class PageAck
    implements ToIntFunction<PagedReference>,
    BooleanSupplier,
    Runnable {
        final Queue targetQueue;
        final String nodeID;
        final long messageID;
        final IOCallback operation;

        PageAck(Queue targetQueue, String nodeID, long messageID, IOCallback operation) {
            this.targetQueue = targetQueue;
            this.nodeID = nodeID;
            this.messageID = messageID;
            this.operation = operation;
        }

        @Override
        public boolean getAsBoolean() {
            try {
                AMQPMirrorControllerTarget.this.recoverContext();
                MessageReference reference = this.targetQueue.removeWithSuppliedID(this.nodeID, this.messageID, (NodeStore)AMQPMirrorControllerTarget.this.referenceNodeStore);
                if (reference == null) {
                    return false;
                }
                this.targetQueue.acknowledge(reference);
                OperationContextImpl.getContext().executeOnCompletion(this.operation);
                return true;
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
                return false;
            }
        }

        @Override
        public int applyAsInt(PagedReference reference) {
            String refNodeID = AMQPMirrorControllerTarget.this.referenceNodeStore.getServerID((MessageReference)reference);
            long refMessageID = AMQPMirrorControllerTarget.this.referenceNodeStore.getID((MessageReference)reference);
            if (refNodeID == null) {
                refNodeID = AMQPMirrorControllerTarget.this.referenceNodeStore.getDefaultNodeID();
            }
            if (refNodeID.equals(this.nodeID)) {
                long diff = refMessageID - this.messageID;
                if (diff == 0L) {
                    return 0;
                }
                if (diff > 0L) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }

        @Override
        public void run() {
            this.operation.done();
        }
    }

    class ACKMessageOperation
    implements IOCallback,
    Runnable {
        Delivery delivery;
        public TransactionOperationAbstract tx = new TransactionOperationAbstract(){

            public void afterCommit(Transaction tx) {
                ACKMessageOperation.this.connectionRun();
            }
        };

        ACKMessageOperation() {
        }

        void reset() {
            this.delivery = null;
        }

        ACKMessageOperation setDelivery(Delivery delivery) {
            this.delivery = delivery;
            return this;
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Delivery settling for " + this.delivery + ", context=" + this.delivery.getContext()));
            }
            this.delivery.disposition((DeliveryState)Accepted.getInstance());
            AMQPMirrorControllerTarget.this.settle(this.delivery);
            AMQPMirrorControllerTarget.this.connection.flush();
            AMQPMirrorControllerTarget.this.ackMessageMpscPool.release((Object)this);
        }

        public void done() {
            this.connectionRun();
        }

        public void connectionRun() {
            AMQPMirrorControllerTarget.this.connection.runNow(this);
        }

        public void onError(int errorCode, String errorMessage) {
            logger.warn((Object)(errorMessage + "-" + errorMessage));
        }
    }
}

