/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.logging.Logger;
import org.jboss.modcluster.ModClusterLogger;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProviderMBean;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.modcluster.load.metric.NodeUnavailableException;

public class DynamicLoadBalanceFactorProvider
implements LoadBalanceFactorProvider,
DynamicLoadBalanceFactorProviderMBean {
    public static final int DEFAULT_INITIAL_LOAD = 0;
    public static final float DEFAULT_DECAY_FACTOR = 2.0f;
    public static final int DEFAULT_HISTORY = 9;
    private final Logger log = Logger.getLogger(this.getClass());
    private final Map<LoadMetric, List<Double>> loadHistory = new LinkedHashMap<LoadMetric, List<Double>>();
    private volatile float decayFactor = 2.0f;
    private volatile int history = 9;

    public DynamicLoadBalanceFactorProvider(Set<LoadMetric> metrics) {
        this(metrics, 0);
    }

    public DynamicLoadBalanceFactorProvider(Set<LoadMetric> metrics, int initialLoad) {
        for (LoadMetric metric : metrics) {
            ArrayList<Double> history = new ArrayList<Double>(this.history + 1);
            if (initialLoad != -1) {
                if (initialLoad < 0 || initialLoad > 100) {
                    throw ModClusterLogger.LOGGER.invalidInitialLoad(initialLoad);
                }
                double transformedLoad = 1.0 - (double)initialLoad / 100.0;
                for (int i = 0; i < this.history; ++i) {
                    history.add(transformedLoad);
                }
            }
            this.loadHistory.put(metric, history);
        }
    }

    @Override
    public synchronized Map<String, Double> getMetrics() {
        TreeMap<String, Double> metrics = new TreeMap<String, Double>();
        for (Map.Entry<LoadMetric, List<Double>> entry : this.loadHistory.entrySet()) {
            List<Double> history = entry.getValue();
            metrics.put(entry.getKey().getClass().getSimpleName(), history.isEmpty() ? 0.0 : history.get(0));
        }
        return metrics;
    }

    public synchronized int getLoadBalanceFactor(Engine engine) {
        boolean nodeUnavailable = false;
        int totalWeight = 0;
        double totalWeightedLoad = 0.0;
        for (Map.Entry<LoadMetric, List<Double>> entry : this.loadHistory.entrySet()) {
            LoadMetric metric = entry.getKey();
            int weight = metric.getWeight();
            if (weight <= 0) continue;
            List<Double> metricLoadHistory = entry.getValue();
            try {
                this.recordLoad(metricLoadHistory, metric.getLoad(engine) / metric.getCapacity());
                totalWeight += weight;
                totalWeightedLoad += this.average(metricLoadHistory) * (double)weight;
            }
            catch (NodeUnavailableException e) {
                nodeUnavailable = true;
            }
            catch (Exception e) {
                this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (nodeUnavailable) {
            return -1;
        }
        int load = (int)Math.round(100.0 * totalWeightedLoad / (double)totalWeight);
        return 100 - Math.max(0, Math.min(load, 99));
    }

    private void recordLoad(List<Double> queue, double load) {
        if (!queue.isEmpty()) {
            for (int i = queue.size() - 1; i >= this.history; --i) {
                queue.remove(i);
            }
        }
        queue.add(0, load);
    }

    private double average(List<Double> queue) {
        assert (!queue.isEmpty());
        double totalLoad = 0.0;
        double totalDecay = 0.0;
        double decayFactor = this.decayFactor;
        for (int i = 0; i < queue.size(); ++i) {
            double decay = 1.0 / Math.pow(decayFactor, i);
            totalDecay += decay;
            totalLoad += queue.get(i) * decay;
        }
        return totalLoad / totalDecay;
    }

    @Override
    public float getDecayFactor() {
        return this.decayFactor;
    }

    @Override
    public void setDecayFactor(float decayFactor) {
        this.decayFactor = Math.max(1.0f, decayFactor);
    }

    @Override
    public int getHistory() {
        return this.history;
    }

    @Override
    public void setHistory(int history) {
        this.history = Math.max(0, history);
    }
}

