/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.JGroupsConfiguration;
import org.infinispan.remoting.transport.jgroups.AbstractJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.NamedSocketFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteNamedCache;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.StackType;

public class EmbeddedJGroupsChannelConfigurator
extends AbstractJGroupsChannelConfigurator {
    private static final String PROTOCOL_PREFIX = "org.jgroups.protocols.";
    private final String name;
    private final String parent;
    private JGroupsConfiguration jgroupsConfiguration;
    private final List<ProtocolConfiguration> stack;
    private final RemoteSites remoteSites;

    public EmbeddedJGroupsChannelConfigurator(String name, List<ProtocolConfiguration> stack, RemoteSites remoteSites) {
        this(name, stack, remoteSites, null);
    }

    public EmbeddedJGroupsChannelConfigurator(String name, List<ProtocolConfiguration> stack, RemoteSites remoteSites, String parent) {
        this.name = name;
        this.stack = stack;
        this.remoteSites = remoteSites;
        this.parent = parent;
    }

    public void setConfiguration(JGroupsConfiguration configuration) {
        this.jgroupsConfiguration = configuration;
    }

    public String getProtocolStackString() {
        return this.getProtocolStack().toString();
    }

    public List<ProtocolConfiguration> getProtocolStack() {
        return EmbeddedJGroupsChannelConfigurator.combineStack(this.jgroupsConfiguration.configurator(this.parent), this.stack);
    }

    public List<ProtocolConfiguration> getUncombinedProtocolStack() {
        return this.stack;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JChannel createChannel(String name) throws Exception {
        StackType stackType = org.jgroups.util.Util.getIpStackType();
        List<ProtocolConfiguration> actualStack = EmbeddedJGroupsChannelConfigurator.combineStack(this.jgroupsConfiguration.configurator(this.parent), this.stack);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>(actualStack.size());
        boolean hasRelay2 = false;
        for (ProtocolConfiguration c : actualStack) {
            Protocol protocol;
            try {
                String className = PROTOCOL_PREFIX + c.getProtocolName();
                protocol = (Protocol)Util.getInstanceStrict((String)className, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                protocol = (Protocol)Util.getInstanceStrict((String)c.getProtocolName(), (ClassLoader)this.getClass().getClassLoader());
            }
            ProtocolConfiguration configuration = new ProtocolConfiguration(protocol.getName(), c.getProperties());
            Configurator.initializeAttrs((Protocol)protocol, (ProtocolConfiguration)configuration, (StackType)stackType);
            protocols.add(protocol);
            if (!(protocol instanceof RELAY2)) continue;
            hasRelay2 = true;
            RELAY2 relay2 = (RELAY2)protocol;
            RemoteSites actualSites = this.getRemoteSites();
            if (actualSites.remoteSites.size() == 0) {
                throw Log.CONFIG.jgroupsRelayWithoutRemoteSites(name);
            }
            for (Map.Entry<String, RemoteSite> remoteSite : actualSites.remoteSites.entrySet()) {
                final JGroupsChannelConfigurator configurator = this.jgroupsConfiguration.configurator(remoteSite.getValue().stack);
                SocketFactory socketFactory = this.getSocketFactory();
                String remoteCluster = remoteSite.getValue().cluster;
                if (remoteCluster == null) {
                    remoteCluster = actualSites.defaultCluster;
                }
                if (socketFactory instanceof NamedSocketFactory) {
                    socketFactory = new NamedSocketFactory((NamedSocketFactory)socketFactory, remoteCluster);
                }
                configurator.setSocketFactory(socketFactory);
                for (ChannelListener listener : this.channelListeners) {
                    configurator.addChannelListener(listener);
                }
                RelayConfig.SiteConfig siteConfig = new RelayConfig.SiteConfig(remoteSite.getKey());
                siteConfig.addBridge(new RelayConfig.BridgeConfig(remoteCluster){

                    public JChannel createChannel() throws Exception {
                        return configurator.createChannel(this.getClusterName());
                    }
                });
                relay2.addSite(remoteSite.getKey(), siteConfig);
            }
        }
        if (!hasRelay2 && this.hasSites()) {
            throw Log.CONFIG.jgroupsRemoteSitesWithoutRelay(name);
        }
        return this.amendChannel(new JChannel(protocols));
    }

    private static List<ProtocolConfiguration> combineStack(JGroupsChannelConfigurator baseStack, List<ProtocolConfiguration> stack) {
        ArrayList<ProtocolConfiguration> actualStack = new ArrayList<ProtocolConfiguration>(stack.size());
        if (baseStack != null) {
            for (ProtocolConfiguration originalProtocol : baseStack.getProtocolStack()) {
                ProtocolConfiguration protocol = new ProtocolConfiguration(originalProtocol.getProtocolName(), new HashMap(originalProtocol.getProperties()));
                actualStack.add(protocol);
            }
        }
        for (ProtocolConfiguration protocol : stack) {
            String protocolName = protocol.getProtocolName();
            int position = EmbeddedJGroupsChannelConfigurator.findProtocol(protocolName, actualStack);
            StackCombine mode = position < 0 ? StackCombine.APPEND : StackCombine.COMBINE;
            String stackCombine = (String)protocol.getProperties().remove("stack.combine");
            if (stackCombine != null) {
                mode = StackCombine.valueOf(stackCombine);
            }
            String stackPosition = (String)protocol.getProperties().remove("stack.position");
            switch (mode) {
                case APPEND: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    actualStack.add(protocol);
                    break;
                }
                case COMBINE: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    ((ProtocolConfiguration)actualStack.get(position)).getProperties().putAll(protocol.getProperties());
                    break;
                }
                case REMOVE: {
                    EmbeddedJGroupsChannelConfigurator.assertNoStackPosition(mode, stackPosition);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    actualStack.remove(position);
                    break;
                }
                case REPLACE: {
                    if (stackPosition != null) {
                        position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                        EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    } else {
                        EmbeddedJGroupsChannelConfigurator.assertExisting(mode, protocolName, position);
                    }
                    actualStack.set(position, protocol);
                    break;
                }
                case INSERT_BEFORE: 
                case INSERT_BELOW: {
                    if (stackPosition == null) {
                        throw Log.CONFIG.jgroupsInsertRequiresPosition(protocolName);
                    }
                    position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    actualStack.add(position, protocol);
                    break;
                }
                case INSERT_AFTER: 
                case INSERT_ABOVE: {
                    if (stackPosition == null) {
                        throw Log.CONFIG.jgroupsInsertRequiresPosition(protocolName);
                    }
                    position = EmbeddedJGroupsChannelConfigurator.findProtocol(stackPosition, actualStack);
                    EmbeddedJGroupsChannelConfigurator.assertExisting(mode, stackPosition, position);
                    actualStack.add(position + 1, protocol);
                }
            }
        }
        return actualStack;
    }

    private void combineSites(Map<String, RemoteSite> sites) {
        JGroupsChannelConfigurator parentConfigurator = this.jgroupsConfiguration.configurator(this.parent);
        if (parentConfigurator instanceof EmbeddedJGroupsChannelConfigurator) {
            ((EmbeddedJGroupsChannelConfigurator)parentConfigurator).combineSites(sites);
        }
        if (this.remoteSites != null) {
            sites.putAll(this.remoteSites.remoteSites);
        }
    }

    private boolean hasSites() {
        if (this.remoteSites != null && !this.remoteSites.remoteSites.isEmpty()) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        HashMap<String, RemoteSite> sites = new HashMap<String, RemoteSite>(4);
        JGroupsChannelConfigurator parentConfigurator = this.jgroupsConfiguration.configurator(this.parent);
        if (parentConfigurator instanceof EmbeddedJGroupsChannelConfigurator) {
            ((EmbeddedJGroupsChannelConfigurator)parentConfigurator).combineSites(sites);
        }
        return !sites.isEmpty();
    }

    private static void assertNoStackPosition(StackCombine mode, String stackAfter) {
        if (stackAfter != null) {
            throw Log.CONFIG.jgroupsNoStackPosition(mode.name());
        }
    }

    private static void assertExisting(StackCombine mode, String protocolName, int position) {
        if (position < 0) {
            throw Log.CONFIG.jgroupsNoSuchProtocol(protocolName, mode.name());
        }
    }

    private static int findProtocol(String protocol, List<ProtocolConfiguration> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            if (!protocol.equals(stack.get(i).getProtocolName())) continue;
            return i;
        }
        return -1;
    }

    public RemoteSites getRemoteSites() {
        RemoteSites combinedSites = new RemoteSites(this.remoteSites.defaultStack, this.remoteSites.defaultCluster);
        this.combineSites(combinedSites.remoteSites);
        return combinedSites;
    }

    public RemoteSites getUncombinedRemoteSites() {
        return this.remoteSites;
    }

    public String toString() {
        return "EmbeddedJGroupsChannelConfigurator{name='" + this.name + "', parent='" + this.parent + "', stack=" + this.stack + ", remoteSites=" + this.remoteSites + "}";
    }

    public static class RemoteSites {
        final String defaultCluster;
        final String defaultStack;
        final Map<String, RemoteSite> remoteSites;

        public RemoteSites(String defaultStack, String defaultCluster) {
            this.defaultStack = defaultStack;
            this.defaultCluster = defaultCluster;
            this.remoteSites = new LinkedHashMap<String, RemoteSite>(4);
        }

        public String getDefaultCluster() {
            return this.defaultCluster;
        }

        public String getDefaultStack() {
            return this.defaultStack;
        }

        public Map<String, RemoteSite> getRemoteSites() {
            return this.remoteSites;
        }

        public void addRemoteSite(String stackName, String remoteSite, String cluster, String stack) {
            if (this.remoteSites.containsKey(remoteSite = XSiteNamedCache.cachedString(remoteSite))) {
                throw Log.CONFIG.duplicateRemoteSite(remoteSite, stackName);
            }
            this.remoteSites.put(remoteSite, new RemoteSite(cluster, stack));
        }

        public String toString() {
            return "RemoteSites{defaultCluster='" + this.defaultCluster + "', defaultStack='" + this.defaultStack + "', remoteSites=" + this.remoteSites + "}";
        }
    }

    public static class RemoteSite {
        final String cluster;
        final String stack;

        RemoteSite(String cluster, String stack) {
            this.cluster = cluster;
            this.stack = stack;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getStack() {
            return this.stack;
        }

        public String toString() {
            return "RemoteSite{cluster='" + this.cluster + "', stack='" + this.stack + "'}";
        }
    }

    public static enum StackCombine {
        COMBINE,
        INSERT_AFTER,
        INSERT_ABOVE,
        INSERT_BEFORE,
        INSERT_BELOW,
        REPLACE,
        REMOVE,
        APPEND;

    }
}

