/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Map;
import java.util.Set;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.loading.impl.CriteriaTypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.impl.HqlTypeQueryFactory;
import org.hibernate.search.mapper.orm.massindexing.impl.ConditionalExpression;

public interface TypeQueryFactory<E, I> {
    public static TypeQueryFactory<?, ?> create(SessionFactoryImplementor sessionFactory, EntityPersister entityPersister, String uniquePropertyName) {
        JpaMetamodelImplementor metamodel = sessionFactory.getJpaMetamodel();
        EntityDomainType typeOrNull = metamodel.entity(entityPersister.getEntityName());
        if (typeOrNull != null && !entityPersister.getMappedClass().equals(Map.class)) {
            return CriteriaTypeQueryFactory.create(typeOrNull, uniquePropertyName);
        }
        return new HqlTypeQueryFactory(entityPersister, uniquePropertyName);
    }

    public Query<Long> createQueryForCount(SharedSessionContractImplementor var1, Set<? extends Class<? extends E>> var2);

    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor var1, Set<? extends Class<? extends E>> var2);

    public Query<Long> createQueryForCount(SharedSessionContractImplementor var1, EntityPersister var2, Set<? extends Class<? extends E>> var3, ConditionalExpression var4);

    public Query<I> createQueryForIdentifierListing(SharedSessionContractImplementor var1, EntityPersister var2, Set<? extends Class<? extends E>> var3, ConditionalExpression var4);

    public Query<E> createQueryForLoadByUniqueProperty(SessionImplementor var1, String var2);

    public MultiIdentifierLoadAccess<E> createMultiIdentifierLoadAccess(SessionImplementor var1);

    public boolean uniquePropertyIsTheEntityId();
}

