/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.metamodel.Bindable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.criteria.JpaSelectCriteria;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.internal.SqmQueryPartCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.cte.SqmSearchClauseSpecification;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedCrossJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedEntityJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedListJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedPluralPartJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRoot;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmCteRoot;
import org.hibernate.query.sqm.tree.domain.SqmDerivedRoot;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralPartJoin;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmCteJoin;
import org.hibernate.query.sqm.tree.from.SqmDerivedJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.spi.NavigablePath;

public class QuerySplitter {
    public static <R> SqmSelectStatement<R>[] split(SqmSelectStatement<R> statement, SessionFactoryImplementor sessionFactory) {
        SqmRoot<?> unmappedPolymorphicReference = QuerySplitter.findUnmappedPolymorphicReference(statement.getQueryPart());
        if (unmappedPolymorphicReference == null) {
            return new SqmSelectStatement[]{statement};
        }
        SqmPolymorphicRootDescriptor unmappedPolymorphicDescriptor = (SqmPolymorphicRootDescriptor)unmappedPolymorphicReference.getReferencedPathSource();
        SqmSelectStatement[] expanded = new SqmSelectStatement[unmappedPolymorphicDescriptor.getImplementors().size()];
        int i = -1;
        for (EntityDomainType<?> mappedDescriptor : unmappedPolymorphicDescriptor.getImplementors()) {
            UnmappedPolymorphismReplacer replacer = new UnmappedPolymorphismReplacer(unmappedPolymorphicReference, mappedDescriptor, sessionFactory);
            expanded[++i] = replacer.visitSelectStatement((SqmSelectStatement)statement);
        }
        return expanded;
    }

    private static SqmRoot<?> findUnmappedPolymorphicReference(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            return ((SqmQuerySpec)queryPart).getRoots().stream().filter(sqmRoot -> sqmRoot.getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor).findFirst().orElse(null);
        }
        SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
        SqmRoot<?> root = QuerySplitter.findUnmappedPolymorphicReference(queryGroup.getQueryParts().get(0));
        if (root != null) {
            throw new UnsupportedOperationException("Polymorphic query group is unsupported");
        }
        return null;
    }

    public static <R> SqmDeleteStatement<R>[] split(SqmDeleteStatement<R> statement, SessionFactoryImplementor sessionFactory) {
        SqmRoot<?> unmappedPolymorphicReference = QuerySplitter.findUnmappedPolymorphicReference(statement);
        if (unmappedPolymorphicReference == null) {
            return new SqmDeleteStatement[]{statement};
        }
        SqmPolymorphicRootDescriptor unmappedPolymorphicDescriptor = (SqmPolymorphicRootDescriptor)unmappedPolymorphicReference.getReferencedPathSource();
        SqmDeleteStatement[] expanded = new SqmDeleteStatement[unmappedPolymorphicDescriptor.getImplementors().size()];
        int i = -1;
        for (EntityDomainType<?> mappedDescriptor : unmappedPolymorphicDescriptor.getImplementors()) {
            UnmappedPolymorphismReplacer replacer = new UnmappedPolymorphismReplacer(unmappedPolymorphicReference, mappedDescriptor, sessionFactory);
            expanded[++i] = replacer.visitDeleteStatement((SqmDeleteStatement)statement);
        }
        return expanded;
    }

    private static SqmRoot<?> findUnmappedPolymorphicReference(SqmDeleteOrUpdateStatement<?> queryPart) {
        if (((AbstractSqmPath)((Object)queryPart.getTarget())).getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor) {
            return queryPart.getTarget();
        }
        return null;
    }

    private static class UnmappedPolymorphismReplacer<R>
    extends BaseSemanticQueryWalker
    implements SqmCreationState {
        private final SqmRoot unmappedPolymorphicFromElement;
        private final EntityDomainType<R> mappedDescriptor;
        private final SqmCreationContext creationContext;
        private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>(SqmCreationProcessingState.class);
        private final Map<NavigablePath, SqmPath> sqmPathCopyMap = new HashMap<NavigablePath, SqmPath>();
        private final Map<SqmFrom, SqmFrom> sqmFromCopyMap = new HashMap<SqmFrom, SqmFrom>();
        private SqmFromClause currentFromClauseCopy = null;

        private UnmappedPolymorphismReplacer(SqmRoot unmappedPolymorphicFromElement, EntityDomainType mappedDescriptor, SessionFactoryImplementor sessionFactory) {
            super(sessionFactory.getServiceRegistry());
            this.unmappedPolymorphicFromElement = unmappedPolymorphicFromElement;
            this.mappedDescriptor = mappedDescriptor;
            this.creationContext = sessionFactory;
        }

        @Override
        public SqmInsertSelectStatement<R> visitInsertSelectStatement(SqmInsertSelectStatement<?> statement) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmUpdateStatement<R> visitUpdateStatement(SqmUpdateStatement<?> statement) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmSetClause visitSetClause(SqmSetClause setClause) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public SqmAssignment<?> visitAssignment(SqmAssignment<?> assignment) {
            throw new UnsupportedOperationException("Not valid");
        }

        @Override
        public Object visitCteContainer(SqmCteContainer consumer) {
            SqmCteContainer processingQuery = (SqmCteContainer)((Object)this.getProcessingStateStack().getCurrent().getProcessingQuery());
            for (SqmCteStatement<?> cteStatement : consumer.getCteStatements()) {
                this.visitCteStatement((SqmCteStatement)cteStatement);
            }
            return processingQuery;
        }

        @Override
        public SqmCteStatement<?> visitCteStatement(SqmCteStatement<?> sqmCteStatement) {
            SqmCteContainer processingQuery = (SqmCteContainer)((Object)this.getProcessingStateStack().getCurrent().getProcessingQuery());
            JpaSelectCriteria cteDefinition = sqmCteStatement.getCteDefinition();
            JpaQueryPart queryPart = cteDefinition.getQueryPart();
            JpaCteCriteria<Object> cteCriteria = null;
            if (cteDefinition.getCteStatements().isEmpty() && queryPart instanceof SqmQueryGroup && ((SqmQueryPart)queryPart).getSortSpecifications().isEmpty() && ((SqmQueryPart)queryPart).getFetchExpression() == null && ((SqmQueryPart)queryPart).getOffsetExpression() == null) {
                SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
                boolean unionDistinct = false;
                switch (queryGroup.getSetOperator()) {
                    case UNION: {
                        unionDistinct = true;
                    }
                    case UNION_ALL: {
                        if (queryGroup.getQueryParts().size() != 2) break;
                        SqmSelectQuery<Object> nonRecursiveStatement = this.visitSelectQuery((SqmSelectQuery<?>)cteDefinition, queryGroup.getQueryParts().get(0));
                        Function recursiveCriteriaProducer = arg_0 -> this.lambda$visitCteStatement$0((SqmSelectQuery)cteDefinition, queryGroup, arg_0);
                        cteCriteria = sqmCteStatement.getName() == null ? (unionDistinct ? processingQuery.withRecursiveUnionDistinct(nonRecursiveStatement, recursiveCriteriaProducer) : processingQuery.withRecursiveUnionAll(nonRecursiveStatement, recursiveCriteriaProducer)) : (unionDistinct ? processingQuery.withRecursiveUnionDistinct(sqmCteStatement.getName(), nonRecursiveStatement, recursiveCriteriaProducer) : processingQuery.withRecursiveUnionAll(sqmCteStatement.getName(), nonRecursiveStatement, recursiveCriteriaProducer));
                        if (sqmCteStatement.getSearchClauseKind() != null) {
                            List<JpaSearchOrder> searchBySpecifications = sqmCteStatement.getSearchBySpecifications();
                            ArrayList<JpaSearchOrder> newSearchBySpecifications = new ArrayList<JpaSearchOrder>(searchBySpecifications.size());
                            for (JpaSearchOrder searchBySpecification : searchBySpecifications) {
                                newSearchBySpecifications.add(new SqmSearchClauseSpecification((SqmCteTableColumn)cteCriteria.getType().getAttribute(searchBySpecification.getAttribute().getName()), searchBySpecification.getSortOrder(), searchBySpecification.getNullPrecedence()));
                            }
                            cteCriteria.search(sqmCteStatement.getSearchClauseKind(), sqmCteStatement.getSearchAttributeName(), newSearchBySpecifications);
                        }
                        if (sqmCteStatement.getCycleMarkAttributeName() == null) break;
                        List<JpaCteCriteriaAttribute> cycleAttributes = sqmCteStatement.getCycleAttributes();
                        ArrayList<JpaCteCriteriaAttribute> newCycleAttributes = new ArrayList<JpaCteCriteriaAttribute>(cycleAttributes.size());
                        for (JpaCteCriteriaAttribute cycleAttribute : cycleAttributes) {
                            newCycleAttributes.add(cteCriteria.getType().getAttribute(cycleAttribute.getName()));
                        }
                        cteCriteria.cycleUsing(sqmCteStatement.getCycleMarkAttributeName(), sqmCteStatement.getCyclePathAttributeName(), sqmCteStatement.getCycleValue(), sqmCteStatement.getNoCycleValue(), newCycleAttributes);
                    }
                }
            }
            if (cteCriteria == null) {
                cteCriteria = sqmCteStatement.getName() == null ? processingQuery.with(this.visitSelectQuery((SqmSelectQuery)cteDefinition)) : processingQuery.with(sqmCteStatement.getName(), this.visitSelectQuery((SqmSelectQuery)cteDefinition));
            }
            if (sqmCteStatement.getMaterialization() != null) {
                cteCriteria.setMaterialization(sqmCteStatement.getMaterialization());
            }
            return (SqmCteStatement)cteCriteria;
        }

        @Override
        public SqmCteStatement<?> findCteStatement(String name) {
            return this.processingStateStack.findCurrentFirstWithParameter(name, UnmappedPolymorphismReplacer::matchCteStatement);
        }

        private static SqmCteStatement<?> matchCteStatement(SqmCreationProcessingState state, String cteName) {
            SqmQuery<?> processingQuery = state.getProcessingQuery();
            if (processingQuery instanceof SqmCteContainer) {
                SqmCteContainer container = (SqmCteContainer)((Object)processingQuery);
                return container.getCteStatement(cteName);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SqmDeleteStatement<R> visitDeleteStatement(SqmDeleteStatement<?> statement) {
            JpaRoot sqmRoot = statement.getTarget();
            SqmRoot<R> copy = new SqmRoot<R>(this.mappedDescriptor, ((AbstractSqmFrom)((Object)sqmRoot)).getExplicitAlias(), ((SqmRoot)sqmRoot).isAllowJoins(), (NodeBuilder)((AbstractSqmExpression)((Object)sqmRoot)).nodeBuilder());
            this.sqmFromCopyMap.put((SqmFrom)((Object)sqmRoot), copy);
            this.sqmPathCopyMap.put(((AbstractSqmPath)((Object)sqmRoot)).getNavigablePath(), copy);
            SqmDeleteStatement<R> statementCopy = new SqmDeleteStatement<R>(copy, statement.getQuerySource(), statement.nodeBuilder());
            this.processingStateStack.push(new SqmDmlCreationProcessingState(statementCopy, this));
            this.getProcessingStateStack().getCurrent().getPathRegistry().register(copy);
            try {
                this.visitCteContainer(statement);
                statementCopy.setWhereClause(this.visitWhereClause(statement.getWhereClause()));
            }
            finally {
                this.processingStateStack.pop();
            }
            return statementCopy;
        }

        @Override
        public SqmSelectStatement<R> visitSelectStatement(SqmSelectStatement<?> statement) {
            SqmSelectStatement copy = new SqmSelectStatement(statement.nodeBuilder());
            this.processingStateStack.push(new SqmQueryPartCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), copy, this));
            try {
                this.visitCteContainer(statement);
                copy.setQueryPart(this.visitQueryPart((SqmQueryPart)statement.getQueryPart()));
            }
            finally {
                this.processingStateStack.pop();
            }
            return copy;
        }

        @Override
        protected SqmSelectQuery<Object> visitSelectQuery(SqmSelectQuery<?> selectQuery) {
            if (selectQuery instanceof SqmSelectStatement) {
                return this.visitSelectStatement((SqmSelectStatement)selectQuery);
            }
            return this.visitSubQueryExpression((SqmSubQuery)selectQuery);
        }

        protected SqmSelectQuery<Object> visitSelectQuery(SqmSelectQuery<?> selectQuery, SqmQueryPart<?> queryPart) {
            if (selectQuery instanceof SqmSelectStatement) {
                SqmSelectStatement sqmSelectStatement = (SqmSelectStatement)selectQuery;
                return this.visitSelectStatement(new SqmSelectStatement(queryPart, sqmSelectStatement.getResultType(), sqmSelectStatement.getQuerySource(), sqmSelectStatement.nodeBuilder()));
            }
            SqmSubQuery sqmSubQuery = (SqmSubQuery)selectQuery;
            return this.visitSubQueryExpression(new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), queryPart, sqmSubQuery.getResultType(), sqmSubQuery.nodeBuilder()));
        }

        @Override
        public SqmQueryPart<R> visitQueryPart(SqmQueryPart<?> queryPart) {
            return (SqmQueryPart)super.visitQueryPart(queryPart);
        }

        @Override
        public SqmQueryGroup<R> visitQueryGroup(SqmQueryGroup<?> queryGroup) {
            List<SqmQueryPart<?>> queryParts = queryGroup.getQueryParts();
            int size = queryParts.size();
            ArrayList newQueryParts = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                newQueryParts.add(this.visitQueryPart((SqmQueryPart)queryParts.get(i)));
            }
            return new SqmQueryGroup(queryGroup.nodeBuilder(), queryGroup.getSetOperator(), newQueryParts);
        }

        @Override
        public SqmQuerySpec<R> visitQuerySpec(SqmQuerySpec<?> querySpec) {
            SqmQuerySpec sqmQuerySpec = new SqmQuerySpec(querySpec.nodeBuilder());
            sqmQuerySpec.setFromClause(this.visitFromClause(querySpec.getFromClause()));
            sqmQuerySpec.setSelectClause(this.visitSelectClause(querySpec.getSelectClause()));
            sqmQuerySpec.setWhereClause(this.visitWhereClause(querySpec.getWhereClause()));
            sqmQuerySpec.setGroupByClauseExpressions((List<SqmExpression<?>>)this.visitGroupByClause((List)querySpec.getGroupByClauseExpressions()));
            sqmQuerySpec.setHavingClausePredicate(this.visitHavingClause(querySpec.getHavingClausePredicate()));
            sqmQuerySpec.setOrderByClause(this.visitOrderByClause(querySpec.getOrderByClause()));
            if (querySpec.getFetchExpression() != null) {
                sqmQuerySpec.setFetchExpression((SqmExpression)querySpec.getFetchExpression().accept(this), querySpec.getFetchClauseType());
            }
            if (querySpec.getOffsetExpression() != null) {
                sqmQuerySpec.setOffsetExpression((SqmExpression)querySpec.getOffsetExpression().accept(this));
            }
            return sqmQuerySpec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SqmFromClause visitFromClause(SqmFromClause fromClause) {
            SqmFromClause previousCurrent = this.currentFromClauseCopy;
            try {
                SqmFromClause copy;
                this.currentFromClauseCopy = copy = new SqmFromClause(fromClause.getNumberOfRoots());
                super.visitFromClause(fromClause);
                SqmFromClause sqmFromClause = copy;
                return sqmFromClause;
            }
            finally {
                this.currentFromClauseCopy = previousCurrent;
            }
        }

        @Override
        public List<SqmExpression<?>> visitGroupByClause(List<SqmExpression<?>> groupByClauseExpressions) {
            if (groupByClauseExpressions.isEmpty()) {
                return groupByClauseExpressions;
            }
            ArrayList expressions = new ArrayList(groupByClauseExpressions.size());
            for (SqmExpression<?> groupByClauseExpression : groupByClauseExpressions) {
                expressions.add((SqmExpression)groupByClauseExpression.accept(this));
            }
            return expressions;
        }

        @Override
        public SqmPredicate visitHavingClause(SqmPredicate sqmPredicate) {
            if (sqmPredicate == null) {
                return null;
            }
            return (SqmPredicate)sqmPredicate.accept(this);
        }

        @Override
        public SqmRoot<?> visitRootPath(SqmRoot<?> sqmRoot) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(sqmRoot);
            if (sqmFrom != null) {
                return (SqmRoot)sqmFrom;
            }
            Bindable pathSource = sqmRoot == this.unmappedPolymorphicFromElement ? this.mappedDescriptor : sqmRoot.getModel();
            SqmRoot copy = new SqmRoot(pathSource, sqmRoot.getExplicitAlias(), sqmRoot.isAllowJoins(), (NodeBuilder)sqmRoot.nodeBuilder());
            this.getProcessingStateStack().getCurrent().getPathRegistry().register(copy);
            this.sqmFromCopyMap.put(sqmRoot, copy);
            this.sqmPathCopyMap.put(sqmRoot.getNavigablePath(), copy);
            if (this.currentFromClauseCopy != null) {
                this.currentFromClauseCopy.addRoot(copy);
            }
            return copy;
        }

        @Override
        public SqmDerivedRoot<?> visitRootDerived(SqmDerivedRoot<?> sqmRoot) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(sqmRoot);
            if (sqmFrom != null) {
                return (SqmDerivedRoot)sqmFrom;
            }
            SqmDerivedRoot copy = new SqmDerivedRoot((SqmSubQuery)((SqmSubQuery)sqmRoot.getQueryPart()).accept(this), sqmRoot.getExplicitAlias());
            this.getProcessingStateStack().getCurrent().getPathRegistry().register(copy);
            this.sqmFromCopyMap.put(sqmRoot, copy);
            this.sqmPathCopyMap.put(sqmRoot.getNavigablePath(), copy);
            if (this.currentFromClauseCopy != null) {
                this.currentFromClauseCopy.addRoot(copy);
            }
            return copy;
        }

        @Override
        public SqmCteRoot<?> visitRootCte(SqmCteRoot<?> sqmRoot) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(sqmRoot);
            if (sqmFrom != null) {
                return (SqmCteRoot)sqmFrom;
            }
            SqmCteRoot copy = new SqmCteRoot((SqmCteStatement)sqmRoot.getCte().accept(this), sqmRoot.getExplicitAlias());
            this.getProcessingStateStack().getCurrent().getPathRegistry().register(copy);
            this.sqmFromCopyMap.put(sqmRoot, copy);
            this.sqmPathCopyMap.put(sqmRoot.getNavigablePath(), copy);
            if (this.currentFromClauseCopy != null) {
                this.currentFromClauseCopy.addRoot(copy);
            }
            return copy;
        }

        @Override
        public SqmCrossJoin<?> visitCrossJoin(SqmCrossJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmCrossJoin)sqmFrom;
            }
            SqmCrossJoin copy = new SqmCrossJoin(join.getReferencedPathSource(), join.getExplicitAlias(), (SqmRoot)this.sqmFromCopyMap.get(join.findRoot()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedCrossJoin<?> visitCorrelatedCrossJoin(SqmCorrelatedCrossJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmCorrelatedCrossJoin)sqmFrom;
            }
            SqmCorrelatedCrossJoin copy = new SqmCorrelatedCrossJoin((SqmCrossJoin)this.findSqmFromCopy((SqmFrom)join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmPluralPartJoin<?, ?> visitPluralPartJoin(SqmPluralPartJoin<?, ?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmPluralPartJoin)sqmFrom;
            }
            SqmPluralPartJoin copy = new SqmPluralPartJoin(this.sqmFromCopyMap.get(join.getLhs()), join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), (NodeBuilder)join.nodeBuilder());
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedPluralPartJoin<?, ?> visitCorrelatedPluralPartJoin(SqmCorrelatedPluralPartJoin<?, ?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmCorrelatedPluralPartJoin)sqmFrom;
            }
            SqmCorrelatedPluralPartJoin copy = new SqmCorrelatedPluralPartJoin((SqmPluralPartJoin)this.findSqmFromCopy(join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmEntityJoin<?> visitQualifiedEntityJoin(SqmEntityJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmEntityJoin)sqmFrom;
            }
            SqmRoot sqmRoot = (SqmRoot)this.sqmFromCopyMap.get(join.findRoot());
            SqmEntityJoin copy = new SqmEntityJoin(join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), sqmRoot);
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedRootJoin<?> visitCorrelatedRootJoin(SqmCorrelatedRootJoin<?> correlatedRootJoin) {
            SqmCorrelatedRootJoin sqmFrom = (SqmCorrelatedRootJoin)this.sqmFromCopyMap.get(correlatedRootJoin);
            if (sqmFrom != null) {
                return sqmFrom;
            }
            SqmCorrelatedRootJoin copy = new SqmCorrelatedRootJoin(correlatedRootJoin.getNavigablePath(), correlatedRootJoin.getReferencedPathSource(), (NodeBuilder)correlatedRootJoin.nodeBuilder());
            correlatedRootJoin.visitReusablePaths(path -> path.accept(this));
            this.sqmFromCopyMap.put(correlatedRootJoin, copy);
            this.sqmPathCopyMap.put(correlatedRootJoin.getNavigablePath(), copy);
            correlatedRootJoin.visitSqmJoins(sqmJoin -> sqmJoin.accept(this));
            return copy;
        }

        @Override
        public SqmCorrelatedRoot<?> visitCorrelatedRoot(SqmCorrelatedRoot<?> correlatedRoot) {
            SqmCorrelatedRoot sqmFrom = (SqmCorrelatedRoot)this.sqmFromCopyMap.get(correlatedRoot);
            if (sqmFrom != null) {
                return sqmFrom;
            }
            SqmCorrelatedRoot copy = new SqmCorrelatedRoot((SqmRoot)this.findSqmFromCopy((SqmFrom)correlatedRoot.getCorrelationParent()));
            correlatedRoot.visitReusablePaths(path -> path.accept(this));
            this.sqmFromCopyMap.put(correlatedRoot, copy);
            this.sqmPathCopyMap.put(correlatedRoot.getNavigablePath(), copy);
            correlatedRoot.visitSqmJoins(sqmJoin -> sqmJoin.accept(this));
            return copy;
        }

        @Override
        public SqmBagJoin<?, ?> visitBagJoin(SqmBagJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmBagJoin)existing;
            }
            SqmBagJoin copy = new SqmBagJoin(this.findSqmFromCopy((SqmFrom)join.getLhs()), join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), join.isFetched(), (NodeBuilder)join.nodeBuilder());
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedBagJoin<?, ?> visitCorrelatedBagJoin(SqmCorrelatedBagJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmCorrelatedBagJoin)existing;
            }
            SqmCorrelatedBagJoin copy = new SqmCorrelatedBagJoin((SqmBagJoin)this.findSqmFromCopy((SqmFrom)join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedListJoin<?, ?> visitCorrelatedListJoin(SqmCorrelatedListJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmCorrelatedListJoin)existing;
            }
            SqmCorrelatedListJoin copy = new SqmCorrelatedListJoin((SqmListJoin)this.findSqmFromCopy((SqmFrom)join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedMapJoin<?, ?, ?> visitCorrelatedMapJoin(SqmCorrelatedMapJoin<?, ?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmCorrelatedMapJoin)existing;
            }
            SqmCorrelatedMapJoin copy = new SqmCorrelatedMapJoin((SqmMapJoin)this.findSqmFromCopy((SqmFrom)join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedSetJoin<?, ?> visitCorrelatedSetJoin(SqmCorrelatedSetJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmCorrelatedSetJoin)existing;
            }
            SqmCorrelatedSetJoin copy = new SqmCorrelatedSetJoin((SqmSetJoin)this.findSqmFromCopy((SqmFrom)join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedSingularJoin<?, ?> visitCorrelatedSingularJoin(SqmCorrelatedSingularJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmCorrelatedSingularJoin)existing;
            }
            SqmCorrelatedSingularJoin copy = new SqmCorrelatedSingularJoin((SqmSingularJoin)this.findSqmFromCopy(join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmListJoin<?, ?> visitListJoin(SqmListJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmListJoin)existing;
            }
            SqmListJoin copy = new SqmListJoin(this.findSqmFromCopy((SqmFrom)join.getLhs()), join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), join.isFetched(), (NodeBuilder)join.nodeBuilder());
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmMapJoin<?, ?, ?> visitMapJoin(SqmMapJoin<?, ?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmMapJoin)existing;
            }
            SqmMapJoin copy = new SqmMapJoin(this.findSqmFromCopy((SqmFrom)join.getLhs()), join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), join.isFetched(), (NodeBuilder)join.nodeBuilder());
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmSetJoin<?, ?> visitSetJoin(SqmSetJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmSetJoin)existing;
            }
            SqmSetJoin copy = new SqmSetJoin(this.findSqmFromCopy((SqmFrom)join.getLhs()), join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), join.isFetched(), (NodeBuilder)join.nodeBuilder());
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmSingularJoin<?, ?> visitSingularJoin(SqmSingularJoin<?, ?> join) {
            SqmFrom existing = this.sqmFromCopyMap.get(join);
            if (existing != null) {
                return (SqmSingularJoin)existing;
            }
            SqmSingularJoin copy = new SqmSingularJoin(this.findSqmFromCopy((SqmFrom)join.getLhs()), join.getReferencedPathSource(), join.getExplicitAlias(), join.getSqmJoinType(), join.isFetched(), (NodeBuilder)join.nodeBuilder());
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmDerivedJoin<?> visitQualifiedDerivedJoin(SqmDerivedJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmDerivedJoin)sqmFrom;
            }
            SqmRoot sqmRoot = (SqmRoot)this.sqmFromCopyMap.get(join.findRoot());
            SqmDerivedJoin copy = new SqmDerivedJoin((SqmSubQuery)((SqmSubQuery)join.getQueryPart()).accept(this), join.getExplicitAlias(), join.getSqmJoinType(), join.isLateral(), sqmRoot);
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCorrelatedEntityJoin<?> visitCorrelatedEntityJoin(SqmCorrelatedEntityJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmCorrelatedEntityJoin)sqmFrom;
            }
            SqmCorrelatedEntityJoin copy = new SqmCorrelatedEntityJoin((SqmEntityJoin)this.findSqmFromCopy((SqmFrom)join.getCorrelationParent()));
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmCteJoin<?> visitQualifiedCteJoin(SqmCteJoin<?> join) {
            SqmFrom sqmFrom = this.sqmFromCopyMap.get(join);
            if (sqmFrom != null) {
                return (SqmCteJoin)sqmFrom;
            }
            SqmRoot sqmRoot = (SqmRoot)this.sqmFromCopyMap.get(join.findRoot());
            SqmCteJoin copy = new SqmCteJoin((SqmCteStatement)join.getCte().accept(this), join.getExplicitAlias(), join.getSqmJoinType(), sqmRoot);
            this.visitJoins(join, copy);
            return copy;
        }

        @Override
        public SqmBasicValuedSimplePath<?> visitBasicValuedPath(SqmBasicValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            SqmPath<?> lhs = this.findLhs(path);
            SqmBasicValuedSimplePath copy = new SqmBasicValuedSimplePath(lhs.getNavigablePath().append(path.getNavigablePath().getLocalName()), path.getReferencedPathSource(), lhs, path.nodeBuilder());
            pathRegistry.register(copy);
            this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
            return copy;
        }

        @Override
        public SqmEmbeddedValuedSimplePath<?> visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            SqmPath<?> lhs = this.findLhs(path);
            SqmEmbeddedValuedSimplePath copy = new SqmEmbeddedValuedSimplePath(lhs.getNavigablePath().append(path.getNavigablePath().getLocalName()), path.getReferencedPathSource(), lhs, path.nodeBuilder());
            pathRegistry.register(copy);
            this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
            return copy;
        }

        @Override
        public SqmEntityValuedSimplePath<?> visitEntityValuedPath(SqmEntityValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            SqmPath<?> lhs = this.findLhs(path);
            SqmEntityValuedSimplePath copy = new SqmEntityValuedSimplePath(lhs.getNavigablePath().append(path.getNavigablePath().getLocalName()), path.getReferencedPathSource(), lhs, path.nodeBuilder());
            pathRegistry.register(copy);
            this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
            return copy;
        }

        @Override
        public SqmPluralValuedSimplePath<?> visitPluralValuedPath(SqmPluralValuedSimplePath<?> path) {
            SqmPathRegistry pathRegistry = this.getProcessingStateStack().getCurrent().getPathRegistry();
            SqmPath<?> lhs = this.findLhs(path);
            SqmPluralValuedSimplePath copy = new SqmPluralValuedSimplePath(path.getNavigablePath(), path.getReferencedPathSource(), lhs, (NodeBuilder)path.nodeBuilder());
            pathRegistry.register(copy);
            this.sqmPathCopyMap.put(path.getNavigablePath(), copy);
            return copy;
        }

        private SqmPath<?> findLhs(SqmPath<?> path) {
            JpaPath lhs = path.getLhs();
            SqmPath lhsSqmPathCopy = this.sqmPathCopyMap.get(lhs.getNavigablePath());
            if (lhsSqmPathCopy != null) {
                return lhsSqmPathCopy;
            }
            return (SqmPath)lhs.accept(this);
        }

        @Override
        public SqmSelectClause visitSelectClause(SqmSelectClause selectClause) {
            SqmSelectClause copy = new SqmSelectClause(selectClause.isDistinct(), selectClause.nodeBuilder());
            for (SqmSelection<?> selection : selectClause.getSelections()) {
                SqmExpression selectableNode = (SqmExpression)selection.getSelectableNode().accept(this);
                copy.addSelection(new SqmSelection(selectableNode, selection.getAlias(), selectClause.nodeBuilder()));
            }
            return copy;
        }

        @Override
        public SqmDynamicInstantiation<?> visitDynamicInstantiation(SqmDynamicInstantiation<?> original) {
            SqmDynamicInstantiation copy;
            SqmDynamicInstantiationTarget<?> instantiationTarget = original.getInstantiationTarget();
            switch (instantiationTarget.getNature()) {
                case MAP: {
                    copy = SqmDynamicInstantiation.forMapInstantiation(instantiationTarget.getTargetTypeDescriptor(), this.getCreationContext().getNodeBuilder());
                    break;
                }
                case LIST: {
                    copy = SqmDynamicInstantiation.forListInstantiation(instantiationTarget.getTargetTypeDescriptor(), this.getCreationContext().getNodeBuilder());
                    break;
                }
                default: {
                    copy = SqmDynamicInstantiation.forClassInstantiation(instantiationTarget.getTargetTypeDescriptor(), this.getCreationContext().getNodeBuilder());
                }
            }
            for (SqmDynamicInstantiationArgument<?> originalArgument : original.getArguments()) {
                copy.addArgument(new SqmDynamicInstantiationArgument((SqmSelectableNode)originalArgument.getSelectableNode().accept(this), originalArgument.getAlias(), this.getCreationContext().getNodeBuilder()));
            }
            return copy;
        }

        @Override
        public SqmWhereClause visitWhereClause(SqmWhereClause whereClause) {
            if (whereClause == null || whereClause.getPredicate() == null) {
                return null;
            }
            return new SqmWhereClause((SqmPredicate)whereClause.getPredicate().accept(this), this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmGroupedPredicate visitGroupedPredicate(SqmGroupedPredicate predicate) {
            SqmPredicate subPredicate = (SqmPredicate)predicate.getSubPredicate().accept(this);
            return new SqmGroupedPredicate(subPredicate, this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmJunctionPredicate visitJunctionPredicate(SqmJunctionPredicate predicate) {
            ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(predicate.getPredicates().size());
            for (SqmPredicate subPredicate : predicate.getPredicates()) {
                predicates.add((SqmPredicate)subPredicate.accept(this));
            }
            return new SqmJunctionPredicate(predicate.getOperator(), predicates, this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
            return new SqmComparisonPredicate((SqmExpression)predicate.getLeftHandExpression().accept(this), predicate.getSqmOperator(), (SqmExpression)predicate.getRightHandExpression().accept(this), this.getCreationContext().getNodeBuilder());
        }

        @Override
        public SqmEmptinessPredicate visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
            return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)predicate.getPluralPath().accept(this), predicate.isNegated(), (NodeBuilder)predicate.nodeBuilder());
        }

        @Override
        public SqmNullnessPredicate visitIsNullPredicate(SqmNullnessPredicate predicate) {
            return new SqmNullnessPredicate((SqmExpression)predicate.getExpression().accept(this), predicate.isNegated(), (NodeBuilder)predicate.nodeBuilder());
        }

        @Override
        public SqmBetweenPredicate visitBetweenPredicate(SqmBetweenPredicate predicate) {
            return new SqmBetweenPredicate((SqmExpression)predicate.getExpression().accept(this), (SqmExpression)predicate.getLowerBound().accept(this), (SqmExpression)predicate.getUpperBound().accept(this), predicate.isNegated(), predicate.nodeBuilder());
        }

        @Override
        public SqmLikePredicate visitLikePredicate(SqmLikePredicate predicate) {
            return new SqmLikePredicate((SqmExpression)predicate.getMatchExpression().accept(this), (SqmExpression)predicate.getPattern().accept(this), predicate.getEscapeCharacter() == null ? null : (SqmExpression)predicate.getEscapeCharacter().accept(this), predicate.nodeBuilder());
        }

        @Override
        public SqmMemberOfPredicate visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
            SqmPath pathCopy = this.sqmPathCopyMap.get(predicate.getPluralPath().getNavigablePath());
            return new SqmMemberOfPredicate(predicate.getLeftHandExpression(), pathCopy, (NodeBuilder)predicate.nodeBuilder());
        }

        @Override
        public SqmNegatedPredicate visitNegatedPredicate(SqmNegatedPredicate predicate) {
            return new SqmNegatedPredicate((SqmPredicate)predicate.getWrappedPredicate().accept(this), (NodeBuilder)predicate.nodeBuilder());
        }

        @Override
        public SqmInSubQueryPredicate visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
            return new SqmInSubQueryPredicate((SqmExpression)predicate.getTestExpression().accept(this), this.visitSubQueryExpression(predicate.getSubQueryExpression()), (NodeBuilder)predicate.nodeBuilder());
        }

        @Override
        public SqmOrderByClause visitOrderByClause(SqmOrderByClause orderByClause) {
            if (orderByClause == null || orderByClause.getSortSpecifications().isEmpty()) {
                return null;
            }
            SqmOrderByClause copy = new SqmOrderByClause();
            for (SqmSortSpecification sortSpecification : orderByClause.getSortSpecifications()) {
                copy.addSortSpecification(this.visitSortSpecification(sortSpecification));
            }
            return copy;
        }

        @Override
        public SqmSortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
            return new SqmSortSpecification((SqmExpression)sortSpecification.getSortExpression().accept(this), sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence());
        }

        @Override
        public SqmPositionalParameter visitPositionalParameterExpression(SqmPositionalParameter<?> expression) {
            return expression;
        }

        @Override
        public SqmNamedParameter visitNamedParameterExpression(SqmNamedParameter<?> expression) {
            return expression;
        }

        @Override
        public SqmLiteralEntityType visitEntityTypeLiteralExpression(SqmLiteralEntityType<?> expression) {
            return new SqmLiteralEntityType(expression.getNodeType(), (NodeBuilder)expression.nodeBuilder());
        }

        @Override
        public SqmUnaryOperation visitUnaryOperationExpression(SqmUnaryOperation<?> expression) {
            return new SqmUnaryOperation(expression.getOperation(), (SqmExpression)expression.getOperand().accept(this));
        }

        @Override
        public SqmLiteral visitLiteral(SqmLiteral<?> literal) {
            return new SqmLiteral(literal.getLiteralValue(), literal.getNodeType(), literal.nodeBuilder());
        }

        @Override
        public SqmBinaryArithmetic visitBinaryArithmeticExpression(SqmBinaryArithmetic<?> expression) {
            return new SqmBinaryArithmetic(expression.getOperator(), (SqmExpression)expression.getLeftHandOperand().accept(this), (SqmExpression)expression.getRightHandOperand().accept(this), expression.getNodeType(), (NodeBuilder)expression.nodeBuilder());
        }

        @Override
        public SqmSubQuery visitSubQueryExpression(SqmSubQuery<?> expression) {
            return new SqmSubQuery(this.getProcessingStateStack().getCurrent().getProcessingQuery(), this.visitQueryPart((SqmQueryPart)expression.getQueryPart()), expression.getResultType(), expression.nodeBuilder());
        }

        @Override
        public Object visitAny(SqmAny<?> sqmAny) {
            return new SqmAny((SqmSubQuery)sqmAny.getSubquery().accept(this), this.creationContext.getNodeBuilder());
        }

        @Override
        public Object visitTreatedPath(SqmTreatedPath<?, ?> sqmTreatedPath) {
            throw new UnsupportedOperationException("Polymorphic queries: treat operator is not supported");
        }

        @Override
        public Object visitEvery(SqmEvery<?> sqmEvery) {
            sqmEvery.getSubquery().accept(this);
            return new SqmEvery((SqmSubQuery)sqmEvery.getSubquery().accept(this), this.creationContext.getNodeBuilder());
        }

        @Override
        public Stack<SqmCreationProcessingState> getProcessingStateStack() {
            return this.processingStateStack;
        }

        @Override
        public SqmCreationContext getCreationContext() {
            return this.creationContext;
        }

        @Override
        public SqmCreationOptions getCreationOptions() {
            return () -> false;
        }

        public <X extends SqmFrom<?, ?>> X findSqmFromCopy(SqmFrom sqmFrom) {
            SqmFrom copy = this.sqmFromCopyMap.get(sqmFrom);
            if (copy != null) {
                return (X)copy;
            }
            return (X)((SqmFrom)sqmFrom.accept(this));
        }

        private void visitJoins(SqmFrom<?, ?> join, SqmJoin copy) {
            this.getProcessingStateStack().getCurrent().getPathRegistry().register(copy);
            this.sqmFromCopyMap.put(join, copy);
            this.sqmPathCopyMap.put(join.getNavigablePath(), copy);
            join.visitSqmJoins(sqmJoin -> sqmJoin.accept(this));
            SqmFrom lhs = (SqmFrom)copy.getLhs();
            if (lhs != null) {
                lhs.addSqmJoin(copy);
            }
        }

        private /* synthetic */ AbstractQuery lambda$visitCteStatement$0(SqmSelectQuery cteDefinition, SqmQueryGroup queryGroup, JpaCteCriteria jpaCteCriteria) {
            return this.visitSelectQuery(cteDefinition, queryGroup.getQueryParts().get(1));
        }
    }
}

