/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.spi;

import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.spi.NavigablePath;

public class SqmCreationHelper {
    public static final String IMPLICIT_ALIAS = "{implicit}";

    public static NavigablePath buildRootNavigablePath(String base, String alias) {
        return new NavigablePath(base, SqmCreationHelper.determineAlias(alias));
    }

    public static NavigablePath buildSubNavigablePath(NavigablePath lhs, String base, String alias) {
        return lhs.append(base, SqmCreationHelper.determineAlias(alias));
    }

    public static String determineAlias(String alias) {
        if (alias == null) {
            return Long.toString(System.nanoTime());
        }
        if (alias == IMPLICIT_ALIAS) {
            return null;
        }
        return alias;
    }

    public static NavigablePath buildSubNavigablePath(SqmPath<?> lhs, String subNavigable, String alias) {
        if (lhs == null) {
            throw new IllegalArgumentException("`lhs` cannot be null for a sub-navigable reference - " + subNavigable);
        }
        NavigablePath navigablePath = lhs.getNavigablePath();
        if (lhs.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            navigablePath = navigablePath.append(CollectionPart.Nature.ELEMENT.getName());
        }
        return SqmCreationHelper.buildSubNavigablePath(navigablePath, subNavigable, alias);
    }

    private SqmCreationHelper() {
    }
}

