/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractBatchEntitySelectFetchInitializer;

public class BatchEntitySelectFetchInitializer
extends AbstractBatchEntitySelectFetchInitializer {
    private Map<EntityKey, List<ParentInfo>> toBatchLoad;

    public BatchEntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping referencedModelPart, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> identifierAssembler) {
        super(parentAccess, referencedModelPart, fetchedNavigable, concreteDescriptor, identifierAssembler);
    }

    @Override
    protected void registerResolutionListener() {
        this.parentAccess.registerResolutionListener(parentInstance -> {
            AttributeMapping parentAttribute = this.getParentEntityAttribute(this.referencedModelPart.getAttributeName());
            if (parentAttribute != null) {
                this.getParentInfos().add(new ParentInfo(parentInstance, parentAttribute.getStateArrayPosition()));
            }
        });
    }

    private List<ParentInfo> getParentInfos() {
        if (this.toBatchLoad == null) {
            this.toBatchLoad = new HashMap<EntityKey, List<ParentInfo>>();
        }
        return this.toBatchLoad.computeIfAbsent(this.entityKey, key -> new ArrayList());
    }

    @Override
    public boolean isEntityInitialized() {
        return false;
    }

    @Override
    public void endLoading(ExecutionContext context) {
        if (this.toBatchLoad != null) {
            this.toBatchLoad.forEach((entityKey, parentInfos) -> {
                SharedSessionContractImplementor session = context.getSession();
                Object instance = BatchEntitySelectFetchInitializer.loadInstance(entityKey, this.referencedModelPart, session);
                for (ParentInfo parentInfo : parentInfos) {
                    Object parentInstance = parentInfo.parentInstance;
                    BatchEntitySelectFetchInitializer.setInstance(this.firstEntityInitializer, this.referencedModelPart, this.referencedModelPart.getPartName(), parentInfo.propertyIndex, session, instance, parentInstance, session.getPersistenceContext().getEntry(parentInstance));
                }
            });
            this.toBatchLoad.clear();
        }
        this.parentAccess = null;
    }

    protected static void setInstance(EntityInitializer entityInitializer, ToOneAttributeMapping referencedModelPart, String propertyName, int propertyIndex, SharedSessionContractImplementor session, Object instance, Object parentInstance, EntityEntry entry) {
        referencedModelPart.getPropertyAccess().getSetter().set(parentInstance, instance);
        BatchEntitySelectFetchInitializer.updateParentEntityLoadedState(entityInitializer, propertyName, propertyIndex, session, instance, entry);
    }

    private static void updateParentEntityLoadedState(EntityInitializer entityInitializer, String propertyName, int propertyIndex, SharedSessionContractImplementor session, Object instance, EntityEntry entry) {
        Object[] loadedState = entry.getLoadedState();
        if (loadedState != null) {
            loadedState[propertyIndex] = entityInitializer.getEntityDescriptor().getPropertyType(propertyName).deepCopy(instance, session.getFactory());
        }
    }

    public String toString() {
        return "BatchEntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    private static class ParentInfo {
        private final Object parentInstance;
        private final int propertyIndex;

        public ParentInfo(Object parentInstance, int propertyIndex) {
            this.parentInstance = parentInstance;
            this.propertyIndex = propertyIndex;
        }
    }
}

