/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.DynamicFilterAliasGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.internal.BasicEntityIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.CaseStatementDiscriminatorMappingImpl;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.DiscriminatorHelper;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.internal.SqlFragmentPredicate;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.entity.internal.EntityResultJoinedSubclassImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.CompositeType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

@Internal
public class JoinedSubclassEntityPersister
extends AbstractEntityPersister {
    private static final Logger log = Logger.getLogger(JoinedSubclassEntityPersister.class);
    private static final String IMPLICIT_DISCRIMINATOR_ALIAS = "clazz_";
    private final int tableSpan;
    private final boolean hasDuplicateTables;
    private final String[] tableNames;
    private final String[] naturalOrderTableNames;
    private final String[][] tableKeyColumns;
    private final String[][] tableKeyColumnReaders;
    private final String[][] tableKeyColumnReaderTemplates;
    private final String[][] naturalOrderTableKeyColumns;
    private final boolean[] naturalOrderCascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassTableNameClosure;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] naturalOrderPropertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final String[] subclassColumnClosure;
    private final boolean[] isInverseSubclassTable;
    private final boolean[] isNullableSubclassTable;
    private final Map<Object, String> subclassesByDiscriminatorValue = new HashMap<Object, String>();
    private final String[] discriminatorValues;
    private final boolean[] discriminatorAbstract;
    private final String[] notNullColumnNames;
    private final int[] notNullColumnTableNumbers;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final Object discriminatorValue;
    private final String discriminatorSQLString;
    private final BasicType<?> discriminatorType;
    private final String explicitDiscriminatorColumnName;
    private final String discriminatorAlias;
    private final boolean forceDiscriminator;
    private final int coreTableSpan;
    private final int subclassCoreTableSpan;
    private final boolean[] isNullableTable;
    private final boolean[] isInverseTable;
    private final Map<String, Object> discriminatorValuesByTableName;
    private final Map<String, String> discriminatorColumnNameByTableName;
    private final Map<String, String> subclassNameByTableName;
    private final String[][] subclassNamesBySubclassTable;

    @Deprecated(since="6.0")
    public JoinedSubclassEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        this(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public JoinedSubclassEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, RuntimeModelCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        Dialect dialect = creationContext.getDialect();
        SqmFunctionRegistry functionRegistry = creationContext.getFunctionRegistry();
        TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = creationContext.getTypeConfiguration().getBasicTypeRegistry();
        if (persistentClass.isPolymorphic()) {
            this.forceDiscriminator = persistentClass.isForceDiscriminator();
            Value discriminatorMapping = persistentClass.getDiscriminator();
            if (discriminatorMapping != null) {
                log.debug((Object)"Encountered explicit discriminator mapping for joined inheritance");
                Selectable selectable = discriminatorMapping.getSelectables().get(0);
                if (selectable instanceof Formula) {
                    throw new MappingException("Discriminator formulas on joined inheritance hierarchies not supported at this time");
                }
                Column column = (Column)selectable;
                this.explicitDiscriminatorColumnName = column.getQuotedName(dialect);
                this.discriminatorAlias = column.getAlias(dialect, persistentClass.getRootTable());
                this.discriminatorType = DiscriminatorHelper.getDiscriminatorType(persistentClass);
                this.discriminatorValue = DiscriminatorHelper.getDiscriminatorValue(persistentClass);
                this.discriminatorSQLString = DiscriminatorHelper.getDiscriminatorSQLValue(persistentClass, dialect);
            } else {
                this.explicitDiscriminatorColumnName = null;
                this.discriminatorAlias = IMPLICIT_DISCRIMINATOR_ALIAS;
                this.discriminatorType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
                try {
                    this.discriminatorValue = persistentClass.getSubclassId();
                    this.discriminatorSQLString = this.discriminatorValue.toString();
                }
                catch (Exception e) {
                    throw new MappingException("Could not format discriminator value to SQL string", e);
                }
            }
        } else {
            this.explicitDiscriminatorColumnName = null;
            this.discriminatorAlias = IMPLICIT_DISCRIMINATOR_ALIAS;
            this.discriminatorType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
            this.discriminatorValue = null;
            this.discriminatorSQLString = null;
            this.forceDiscriminator = false;
        }
        if (this.optimisticLockStyle().isAllOrDirty()) {
            throw new MappingException("optimistic-lock=all|dirty not supported for joined-subclass mappings [" + this.getEntityName() + "]");
        }
        int idColumnSpan = this.getIdentifierColumnSpan();
        ArrayList<String> tableNames = new ArrayList<String>();
        ArrayList<String[]> keyColumns = new ArrayList<String[]>();
        ArrayList<String[]> keyColumnReaders = new ArrayList<String[]>();
        ArrayList<String[]> keyColumnReaderTemplates = new ArrayList<String[]>();
        ArrayList<Boolean> cascadeDeletes = new ArrayList<Boolean>();
        List<Table> tableClosure = persistentClass.getTableClosure();
        List<KeyValue> keyClosure = persistentClass.getKeyClosure();
        for (int i = 0; i < tableClosure.size() && i < keyClosure.size(); ++i) {
            tableNames.add(this.determineTableName(tableClosure.get(i)));
            KeyValue key = keyClosure.get(i);
            String[] keyCols = new String[idColumnSpan];
            String[] keyColReaders = new String[idColumnSpan];
            String[] keyColReaderTemplates = new String[idColumnSpan];
            List<Column> columns = key.getColumns();
            for (int k = 0; k < idColumnSpan; ++k) {
                Column column = columns.get(k);
                keyCols[k] = column.getQuotedName(dialect);
                keyColReaders[k] = column.getReadExpr(dialect);
                keyColReaderTemplates[k] = column.getTemplate(dialect, typeConfiguration, functionRegistry);
            }
            keyColumns.add(keyCols);
            keyColumnReaders.add(keyColReaders);
            keyColumnReaderTemplates.add(keyColReaderTemplates);
            cascadeDeletes.add(key.isCascadeDeleteEnabled() && dialect.supportsCascadeDelete());
        }
        this.coreTableSpan = tableNames.size();
        this.subclassCoreTableSpan = persistentClass.getSubclassTableClosure().size();
        this.tableSpan = persistentClass.getJoinClosureSpan() + this.coreTableSpan;
        this.isNullableTable = new boolean[this.tableSpan];
        this.isInverseTable = new boolean[this.tableSpan];
        List<Join> joinClosure = persistentClass.getJoinClosure();
        for (int i = 0; i < joinClosure.size(); ++i) {
            Join join = joinClosure.get(i);
            this.isNullableTable[i] = join.isOptional();
            this.isInverseTable[i] = join.isInverse();
            tableNames.add(this.determineTableName(join.getTable()));
            KeyValue key = join.getKey();
            int joinIdColumnSpan = key.getColumnSpan();
            String[] keyCols = new String[joinIdColumnSpan];
            String[] keyColReaders = new String[joinIdColumnSpan];
            String[] keyColReaderTemplates = new String[joinIdColumnSpan];
            Iterator<Join> columns = key.getColumns();
            for (int k = 0; k < joinIdColumnSpan; ++k) {
                Column column = columns.get(k);
                keyCols[k] = column.getQuotedName(dialect);
                keyColReaders[k] = column.getReadExpr(dialect);
                keyColReaderTemplates[k] = column.getTemplate(dialect, typeConfiguration, functionRegistry);
            }
            keyColumns.add(keyCols);
            keyColumnReaders.add(keyColReaders);
            keyColumnReaderTemplates.add(keyColReaderTemplates);
            cascadeDeletes.add(key.isCascadeDeleteEnabled() && dialect.supportsCascadeDelete());
        }
        this.hasDuplicateTables = new HashSet(tableNames).size() == tableNames.size();
        this.naturalOrderTableNames = ArrayHelper.toStringArray(tableNames);
        this.naturalOrderTableKeyColumns = ArrayHelper.to2DStringArray(keyColumns);
        String[][] naturalOrderTableKeyColumnReaders = ArrayHelper.to2DStringArray(keyColumnReaders);
        String[][] naturalOrderTableKeyColumnReaderTemplates = ArrayHelper.to2DStringArray(keyColumnReaderTemplates);
        this.naturalOrderCascadeDeleteEnabled = ArrayHelper.toBooleanArray(cascadeDeletes);
        ArrayList<String> subclassTableNames = new ArrayList<String>();
        ArrayList<Boolean> isConcretes = new ArrayList<Boolean>();
        ArrayList<Boolean> isInverses = new ArrayList<Boolean>();
        ArrayList<Boolean> isNullables = new ArrayList<Boolean>();
        ArrayList<String[]> allKeyColumns = new ArrayList<String[]>();
        for (Table table : persistentClass.getSubclassTableClosure()) {
            isConcretes.add(persistentClass.isClassOrSuperclassTable(table));
            isInverses.add(false);
            isNullables.add(false);
            String tableName = this.determineTableName(table);
            subclassTableNames.add(tableName);
            String[] key = new String[idColumnSpan];
            List<Column> columns = table.getPrimaryKey().getColumnsInOriginalOrder();
            for (int k = 0; k < idColumnSpan; ++k) {
                key[k] = columns.get(k).getQuotedName(dialect);
            }
            allKeyColumns.add(key);
        }
        for (Join join : persistentClass.getSubclassJoinClosure()) {
            Table joinTable = join.getTable();
            isConcretes.add(persistentClass.isClassOrSuperclassTable(joinTable));
            isInverses.add(join.isInverse());
            isNullables.add(join.isOptional());
            String joinTableName = this.determineTableName(joinTable);
            subclassTableNames.add(joinTableName);
            String[] key = new String[idColumnSpan];
            List<Column> columns = joinTable.getPrimaryKey().getColumnsInOriginalOrder();
            for (int k = 0; k < idColumnSpan; ++k) {
                key[k] = columns.get(k).getQuotedName(dialect);
            }
            allKeyColumns.add(key);
        }
        String[] naturalOrderSubclassTableNameClosure = ArrayHelper.toStringArray(subclassTableNames);
        String[][] naturalOrderSubclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(allKeyColumns);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(isConcretes);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(isInverses);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(isNullables);
        this.constraintOrderedTableNames = new String[naturalOrderSubclassTableNameClosure.length];
        this.constraintOrderedKeyColumnNames = new String[naturalOrderSubclassTableNameClosure.length][];
        int currentPosition = 0;
        int i = naturalOrderSubclassTableNameClosure.length - 1;
        while (i >= 0) {
            this.constraintOrderedTableNames[currentPosition] = naturalOrderSubclassTableNameClosure[i];
            this.constraintOrderedKeyColumnNames[currentPosition] = naturalOrderSubclassTableKeyColumnClosure[i];
            --i;
            ++currentPosition;
        }
        this.tableNames = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableNames, this.coreTableSpan);
        this.tableKeyColumns = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumns, this.coreTableSpan);
        this.tableKeyColumnReaders = JoinedSubclassEntityPersister.reverse(naturalOrderTableKeyColumnReaders, this.coreTableSpan);
        this.tableKeyColumnReaderTemplates = JoinedSubclassEntityPersister.reverse(naturalOrderTableKeyColumnReaderTemplates, this.coreTableSpan);
        this.subclassTableNameClosure = JoinedSubclassEntityPersister.reverse(naturalOrderSubclassTableNameClosure, this.coreTableSpan);
        this.subclassTableKeyColumnClosure = JoinedSubclassEntityPersister.reverse(naturalOrderSubclassTableKeyColumnClosure, this.coreTableSpan);
        this.spaces = ArrayHelper.join(this.tableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        this.customSQLInsert = new String[this.tableSpan];
        this.customSQLUpdate = new String[this.tableSpan];
        this.customSQLDelete = new String[this.tableSpan];
        this.insertCallable = new boolean[this.tableSpan];
        this.updateCallable = new boolean[this.tableSpan];
        this.deleteCallable = new boolean[this.tableSpan];
        this.insertExpectations = new Expectation[this.tableSpan];
        this.updateExpectations = new Expectation[this.tableSpan];
        this.deleteExpectations = new Expectation[this.tableSpan];
        int jk = this.coreTableSpan - 1;
        for (PersistentClass currentClass = persistentClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.isNullableTable[jk] = false;
            this.isInverseTable[jk] = false;
            this.customSQLInsert[jk] = currentClass.getCustomSQLInsert();
            this.insertCallable[jk] = this.customSQLInsert[jk] != null && currentClass.isCustomInsertCallable();
            this.insertExpectations[jk] = Expectations.appropriateExpectation(currentClass.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[jk], this.insertCallable[jk]) : currentClass.getCustomSQLInsertCheckStyle());
            this.customSQLUpdate[jk] = currentClass.getCustomSQLUpdate();
            this.updateCallable[jk] = this.customSQLUpdate[jk] != null && currentClass.isCustomUpdateCallable();
            this.updateExpectations[jk] = Expectations.appropriateExpectation(currentClass.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[jk], this.updateCallable[jk]) : currentClass.getCustomSQLUpdateCheckStyle());
            this.customSQLDelete[jk] = currentClass.getCustomSQLDelete();
            this.deleteCallable[jk] = this.customSQLDelete[jk] != null && currentClass.isCustomDeleteCallable();
            this.deleteExpectations[jk] = Expectations.appropriateExpectation(currentClass.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[jk], this.deleteCallable[jk]) : currentClass.getCustomSQLDeleteCheckStyle());
            --jk;
        }
        if (jk != -1) {
            throw new AssertionFailure("Tablespan does not match height of joined-subclass hierarchy.");
        }
        int j = this.coreTableSpan;
        for (Join join : persistentClass.getJoinClosure()) {
            this.isInverseTable[j] = join.isInverse();
            this.isNullableTable[j] = join.isOptional();
            this.customSQLInsert[j] = join.getCustomSQLInsert();
            this.insertCallable[j] = this.customSQLInsert[j] != null && join.isCustomInsertCallable();
            this.insertExpectations[j] = Expectations.appropriateExpectation(join.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[j], this.insertCallable[j]) : join.getCustomSQLInsertCheckStyle());
            this.customSQLUpdate[j] = join.getCustomSQLUpdate();
            this.updateCallable[j] = this.customSQLUpdate[j] != null && join.isCustomUpdateCallable();
            this.updateExpectations[j] = Expectations.appropriateExpectation(join.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[j], this.updateCallable[j]) : join.getCustomSQLUpdateCheckStyle());
            this.customSQLDelete[j] = join.getCustomSQLDelete();
            this.deleteCallable[j] = this.customSQLDelete[j] != null && join.isCustomDeleteCallable();
            this.deleteExpectations[j] = Expectations.appropriateExpectation(join.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[j], this.deleteCallable[j]) : join.getCustomSQLDeleteCheckStyle());
            ++j;
        }
        int hydrateSpan = this.getPropertySpan();
        this.naturalOrderPropertyTableNumbers = new int[hydrateSpan];
        List<Property> propertyClosure = persistentClass.getPropertyClosure();
        for (int i2 = 0; i2 < propertyClosure.size(); ++i2) {
            String tableName = propertyClosure.get(i2).getValue().getTable().getQualifiedName(creationContext.getSqlStringGenerationContext());
            this.naturalOrderPropertyTableNumbers[i2] = JoinedSubclassEntityPersister.getTableId(tableName, this.naturalOrderTableNames);
        }
        ArrayList<Integer> columnTableNumbers = new ArrayList<Integer>();
        ArrayList<Integer> propTableNumbers = new ArrayList<Integer>();
        ArrayList<String> columns = new ArrayList<String>();
        for (Property property : persistentClass.getSubclassPropertyClosure()) {
            String tableName = property.getValue().getTable().getQualifiedName(creationContext.getSqlStringGenerationContext());
            Integer tableNumber = JoinedSubclassEntityPersister.getTableId(tableName, this.subclassTableNameClosure);
            propTableNumbers.add(tableNumber);
            for (Selectable selectable : property.getSelectables()) {
                if (selectable.isFormula()) continue;
                columnTableNumbers.add(tableNumber);
                Column column = (Column)selectable;
                columns.add(column.getQuotedName(dialect));
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray(columnTableNumbers);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propTableNumbers);
        this.subclassColumnClosure = ArrayHelper.toStringArray(columns);
        int subclassSpan = persistentClass.getSubclassSpan() + 1;
        int subclassSpanMinusOne = subclassSpan - 1;
        if (!persistentClass.isPolymorphic()) {
            this.subclassNameByTableName = Collections.emptyMap();
            this.discriminatorValuesByTableName = Collections.emptyMap();
            this.discriminatorColumnNameByTableName = Collections.emptyMap();
            this.discriminatorValues = null;
            this.discriminatorAbstract = null;
            this.notNullColumnTableNumbers = null;
            this.notNullColumnNames = null;
        } else {
            int id;
            this.subclassesByDiscriminatorValue.put(this.discriminatorValue, this.getEntityName());
            this.discriminatorValuesByTableName = CollectionHelper.linkedMapOfSize(subclassSpan + 1);
            this.discriminatorColumnNameByTableName = CollectionHelper.linkedMapOfSize(subclassSpan + 1);
            this.subclassNameByTableName = CollectionHelper.mapOfSize(subclassSpan + 1);
            Table table = persistentClass.getTable();
            this.discriminatorValues = new String[subclassSpan];
            this.discriminatorAbstract = new boolean[subclassSpan];
            this.initDiscriminatorProperties(dialect, subclassSpanMinusOne, table, this.discriminatorValue, JoinedSubclassEntityPersister.isAbstract(persistentClass));
            this.notNullColumnTableNumbers = new int[subclassSpan];
            this.notNullColumnTableNumbers[subclassSpanMinusOne] = id = JoinedSubclassEntityPersister.getTableId(table.getQualifiedName(creationContext.getSqlStringGenerationContext()), this.subclassTableNameClosure);
            this.notNullColumnNames = new String[subclassSpan];
            this.notNullColumnNames[subclassSpanMinusOne] = this.subclassTableKeyColumnClosure[id][0];
            List<Subclass> subclasses = persistentClass.getSubclasses();
            for (int k = 0; k < subclasses.size(); ++k) {
                int tableId;
                Subclass subclass = subclasses.get(k);
                Table subclassTable = subclass.getTable();
                this.subclassNameByTableName.put(subclassTable.getName(), subclass.getEntityName());
                if (!persistentClass.isPolymorphic()) continue;
                Object discriminatorValue = this.explicitDiscriminatorColumnName != null ? DiscriminatorHelper.getDiscriminatorValue(subclass) : Integer.valueOf(subclass.getSubclassId());
                this.initDiscriminatorProperties(dialect, k, subclassTable, discriminatorValue, JoinedSubclassEntityPersister.isAbstract(subclass));
                this.subclassesByDiscriminatorValue.put(discriminatorValue, subclass.getEntityName());
                this.notNullColumnTableNumbers[k] = tableId = JoinedSubclassEntityPersister.getTableId(subclassTable.getQualifiedName(creationContext.getSqlStringGenerationContext()), this.subclassTableNameClosure);
                this.notNullColumnNames[k] = this.subclassTableKeyColumnClosure[tableId][0];
            }
        }
        this.subclassNamesBySubclassTable = this.buildSubclassNamesBySubclassTableMapping(persistentClass, creationContext.getSqlStringGenerationContext());
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(creationContext.getMetadata());
    }

    private void initDiscriminatorProperties(Dialect dialect, int k, Table table, Object discriminatorValue, boolean isAbstract) {
        String tableName = this.determineTableName(table);
        String columnName = table.getPrimaryKey().getColumn(0).getQuotedName(dialect);
        this.discriminatorValuesByTableName.put(tableName, discriminatorValue);
        this.discriminatorColumnNameByTableName.put(tableName, columnName);
        this.discriminatorValues[k] = discriminatorValue.toString();
        this.discriminatorAbstract[k] = isAbstract;
    }

    @Override
    public Map<Object, String> getSubclassByDiscriminatorValue() {
        return this.subclassesByDiscriminatorValue;
    }

    private String[][] buildSubclassNamesBySubclassTableMapping(PersistentClass persistentClass, SqlStringGenerationContext context) {
        int numberOfSubclassTables = this.subclassTableNameClosure.length - this.coreTableSpan;
        if (numberOfSubclassTables == 0) {
            return new String[0][];
        }
        String[][] mapping = new String[numberOfSubclassTables][];
        this.processPersistentClassHierarchy(persistentClass, true, mapping, context);
        return mapping;
    }

    private Set<String> processPersistentClassHierarchy(PersistentClass persistentClass, boolean isBase, String[][] mapping, SqlStringGenerationContext context) {
        HashSet<String> classNames = new HashSet<String>();
        for (Subclass subclass : persistentClass.getDirectSubclasses()) {
            Set<String> subclassSubclassNames = this.processPersistentClassHierarchy(subclass, false, mapping, context);
            classNames.addAll(subclassSubclassNames);
        }
        classNames.add(persistentClass.getEntityName());
        if (!isBase) {
            for (MappedSuperclass msc = persistentClass.getSuperMappedSuperclass(); msc != null; msc = msc.getSuperMappedSuperclass()) {
                classNames.add(msc.getMappedClass().getName());
            }
            this.associateSubclassNamesToSubclassTableIndexes(persistentClass, classNames, mapping, context);
        }
        return classNames;
    }

    private void associateSubclassNamesToSubclassTableIndexes(PersistentClass persistentClass, Set<String> classNames, String[][] mapping, SqlStringGenerationContext context) {
        String tableName = persistentClass.getTable().getQualifiedName(context);
        this.associateSubclassNamesToSubclassTableIndex(tableName, classNames, mapping);
        for (Join join : persistentClass.getJoins()) {
            String secondaryTableName = join.getTable().getQualifiedName(context);
            this.associateSubclassNamesToSubclassTableIndex(secondaryTableName, classNames, mapping);
        }
    }

    private void associateSubclassNamesToSubclassTableIndex(String tableName, Set<String> classNames, String[][] mapping) {
        boolean found = false;
        for (int i = 1; i < this.subclassTableNameClosure.length; ++i) {
            if (!this.subclassTableNameClosure[i].equals(tableName)) continue;
            found = true;
            int index = i - this.coreTableSpan;
            if (index < 0 || index >= mapping.length) {
                throw new IllegalStateException(String.format("Encountered 'subclass table index' [%s] was outside expected range ( [%s] < i < [%s] )", index, 0, mapping.length));
            }
            mapping[index] = ArrayHelper.toStringArray(classNames);
            break;
        }
        if (!found) {
            throw new IllegalStateException(String.format("Was unable to locate subclass table [%s] in 'subclassTableNameClosure'", tableName));
        }
    }

    @Override
    protected boolean needsDiscriminator() {
        return this.forceDiscriminator;
    }

    @Override
    public boolean isNullableTable(int j) {
        return this.isNullableTable[j];
    }

    @Override
    protected void visitMutabilityOrderedTables(AbstractEntityPersister.MutabilityOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.naturalOrderTableNames.length) {
            String tableName = this.naturalOrderTableNames[i];
            int tableIndex = i++;
            consumer.consume(tableName, tableIndex, () -> columnConsumer -> columnConsumer.accept(tableName, this.getIdentifierMapping(), this.naturalOrderTableKeyColumns[tableIndex]));
        }
    }

    @Override
    protected boolean isIdentifierTable(String tableExpression) {
        return tableExpression.equals(this.getRootTableName());
    }

    @Override
    public boolean hasSkippableTables() {
        return this.hasAnySkippableTables(this.isNullableTable, this.isInverseTable);
    }

    @Override
    public boolean isInverseTable(int j) {
        return this.isInverseTable[j];
    }

    @Override
    public String getSubclassPropertyTableName(int i) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i]];
    }

    @Override
    protected boolean isInverseSubclassTable(int j) {
        return this.isInverseSubclassTable[j];
    }

    @Override
    protected boolean isNullableSubclassTable(int j) {
        return this.isNullableSubclassTable[j];
    }

    @Override
    public BasicType<?> getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLString;
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.explicitDiscriminatorColumnName == null ? super.getDiscriminatorColumnName() : this.explicitDiscriminatorColumnName;
    }

    @Override
    public String getDiscriminatorColumnReaders() {
        return this.getDiscriminatorColumnName();
    }

    @Override
    public String getDiscriminatorColumnReaderTemplate() {
        return this.getDiscriminatorColumnName();
    }

    @Override
    public String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }

    @Override
    public String getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return this.subclassesByDiscriminatorValue.get(DiscriminatorHelper.NULL_DISCRIMINATOR);
        }
        String result = this.subclassesByDiscriminatorValue.get(value);
        return result == null ? this.subclassesByDiscriminatorValue.get(DiscriminatorHelper.NOT_NULL_DISCRIMINATOR) : result;
    }

    @Override
    public void addDiscriminatorToInsertGroup(MutationGroupBuilder insertGroupBuilder) {
        if (this.explicitDiscriminatorColumnName != null) {
            TableInsertBuilder tableInsertBuilder = (TableInsertBuilder)insertGroupBuilder.getTableDetailsBuilder(this.getRootTableName());
            String discriminatorValueToUse = this.discriminatorValue == DiscriminatorHelper.NULL_DISCRIMINATOR ? "null" : (this.discriminatorValue == DiscriminatorHelper.NOT_NULL_DISCRIMINATOR ? "not null" : this.discriminatorSQLString);
            tableInsertBuilder.addValueColumn(this.explicitDiscriminatorColumnName, discriminatorValueToUse, this.getDiscriminatorMapping().getJdbcMapping());
        }
    }

    @Override
    public String[] getPropertySpaces() {
        return this.spaces;
    }

    @Override
    public boolean hasDuplicateTables() {
        return this.hasDuplicateTables;
    }

    @Override
    public String getTableName(int j) {
        return this.naturalOrderTableNames[j];
    }

    @Override
    public String[] getKeyColumns(int j) {
        return this.naturalOrderTableKeyColumns[j];
    }

    @Override
    public boolean isTableCascadeDeleteEnabled(int j) {
        return this.naturalOrderCascadeDeleteEnabled[j];
    }

    @Override
    public boolean isPropertyOfTable(int property, int j) {
        return this.naturalOrderPropertyTableNumbers[property] == j;
    }

    private static String[] reverse(String[] objects, int n) {
        int i;
        int size = objects.length;
        String[] temp = new String[size];
        for (i = 0; i < n; ++i) {
            temp[i] = objects[n - i - 1];
        }
        for (i = n; i < size; ++i) {
            temp[i] = objects[i];
        }
        return temp;
    }

    private static String[][] reverse(String[][] objects, int n) {
        int i;
        int size = objects.length;
        String[][] temp = new String[size][];
        for (i = 0; i < n; ++i) {
            temp[i] = objects[n - i - 1];
        }
        for (i = n; i < size; ++i) {
            temp[i] = objects[i];
        }
        return temp;
    }

    @Override
    public String fromTableFragment(String alias) {
        return this.getTableName() + " " + alias;
    }

    @Override
    public String getTableName() {
        return this.tableNames[0];
    }

    @Override
    public String generateFilterConditionAlias(String rootAlias) {
        return JoinedSubclassEntityPersister.generateTableAlias(rootAlias, this.tableSpan - 1);
    }

    @Override
    public String[] getIdentifierColumnNames() {
        return this.tableKeyColumns[0];
    }

    @Override
    public String[] getIdentifierColumnReaderTemplates() {
        return this.tableKeyColumnReaderTemplates[0];
    }

    @Override
    public String getRootTableName() {
        return this.naturalOrderTableNames[0];
    }

    @Override
    public String[] getIdentifierColumnReaders() {
        return this.tableKeyColumnReaders[0];
    }

    @Override
    protected int getSubclassPropertyTableNumber(int i) {
        return this.subclassPropertyTableNumberClosure[i];
    }

    @Override
    public int getTableSpan() {
        return this.tableSpan;
    }

    @Override
    protected boolean hasMultipleTables() {
        return true;
    }

    @Override
    protected int[] getPropertyTableNumbers() {
        return this.naturalOrderPropertyTableNumbers;
    }

    @Override
    protected String[] getSubclassTableKeyColumns(int j) {
        return this.subclassTableKeyColumnClosure[j];
    }

    @Override
    public String getSubclassTableName(int j) {
        return this.subclassTableNameClosure[j];
    }

    @Override
    protected String[] getSubclassTableNames() {
        return this.subclassTableNameClosure;
    }

    @Override
    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    @Override
    protected boolean shouldProcessSuperMapping() {
        return false;
    }

    @Override
    protected boolean isClassOrSuperclassTable(int j) {
        return this.isClassOrSuperclassTable[j];
    }

    @Override
    protected boolean isSubclassTableIndicatedByTreatAsDeclarations(int subclassTableNumber, Set<String> treatAsDeclarations) {
        if (treatAsDeclarations == null || treatAsDeclarations.isEmpty()) {
            return false;
        }
        String[] inclusionSubclassNameClosure = this.getSubclassNameClosureBySubclassTable(subclassTableNumber);
        for (String subclassName : treatAsDeclarations) {
            for (String inclusionSubclassName : inclusionSubclassNameClosure) {
                if (!inclusionSubclassName.equals(subclassName)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getSubclassNameClosureBySubclassTable(int subclassTableNumber) {
        int index = subclassTableNumber - this.getTableSpan();
        if (index >= this.subclassNamesBySubclassTable.length) {
            throw new IllegalArgumentException("Given subclass table number is outside expected range [" + (this.subclassNamesBySubclassTable.length - 1) + "] as defined by subclassTableNameClosure/subclassClosure");
        }
        return this.subclassNamesBySubclassTable[index];
    }

    @Override
    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    @Override
    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    @Override
    public String getRootTableAlias(String drivingAlias) {
        return JoinedSubclassEntityPersister.generateTableAlias(drivingAlias, JoinedSubclassEntityPersister.getTableId(this.getRootTableName(), this.tableNames));
    }

    @Override
    public Queryable.Declarer getSubclassPropertyDeclarer(String propertyPath) {
        if ("class".equals(propertyPath)) {
            return Queryable.Declarer.SUBCLASS;
        }
        return super.getSubclassPropertyDeclarer(propertyPath);
    }

    @Override
    public int determineTableNumberForColumn(String columnName) {
        int i;
        int max = this.naturalOrderTableKeyColumns.length;
        for (i = 0; i < max; ++i) {
            Object[] keyColumns = this.naturalOrderTableKeyColumns[i];
            if (!ArrayHelper.contains(keyColumns, columnName)) continue;
            return this.naturalOrderPropertyTableNumbers[i];
        }
        max = this.subclassColumnClosure.length;
        for (i = 0; i < max; ++i) {
            boolean quoted;
            boolean bl = quoted = this.subclassColumnClosure[i].startsWith("\"") && this.subclassColumnClosure[i].endsWith("\"");
            if (!(quoted ? this.subclassColumnClosure[i].equals(columnName) : this.subclassColumnClosure[i].equalsIgnoreCase(columnName))) continue;
            return this.subclassColumnTableNumberClosure[i];
        }
        throw new HibernateException("Could not locate table which owns column [" + columnName + "] referenced in order-by mapping - " + this.getEntityName());
    }

    @Override
    protected EntityVersionMapping generateVersionMapping(Supplier<?> templateInstanceCreator, PersistentClass bootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        if (this.getVersionType() == null) {
            return null;
        }
        if (this.getTableName().equals(this.getVersionedTableName())) {
            int versionPropertyIndex = this.getVersionProperty();
            String versionPropertyName = this.getPropertyNames()[versionPropertyIndex];
            return creationProcess.processSubPart(versionPropertyName, (role, process) -> JoinedSubclassEntityPersister.generateVersionMapping(this, templateInstanceCreator, bootEntityDescriptor, process));
        }
        if (this.getSuperMappingType() != null) {
            return this.getSuperMappingType().getVersionMapping();
        }
        return null;
    }

    @Override
    protected EntityIdentifierMapping generateIdentifierMapping(Supplier<?> templateInstanceCreator, PersistentClass bootEntityDescriptor, MappingModelCreationProcess creationProcess) {
        Integer scale;
        Integer precision;
        Long length;
        String columnDefinition;
        Type idType = this.getIdentifierType();
        if (idType instanceof CompositeType) {
            boolean encapsulated;
            CompositeType cidType = (CompositeType)idType;
            boolean bl = encapsulated = !cidType.isEmbedded();
            if (encapsulated) {
                return MappingModelCreationHelper.buildEncapsulatedCompositeIdentifierMapping(this, bootEntityDescriptor.getIdentifierProperty(), bootEntityDescriptor.getIdentifierProperty().getName(), this.getTableName(), this.tableKeyColumns[0], cidType, creationProcess);
            }
            return this.generateNonEncapsulatedCompositeIdentifierMapping(creationProcess, bootEntityDescriptor);
        }
        if (bootEntityDescriptor.getIdentifier() == null) {
            columnDefinition = null;
            length = null;
            precision = null;
            scale = null;
        } else {
            Column column = bootEntityDescriptor.getIdentifier().getColumns().get(0);
            columnDefinition = column.getSqlType();
            length = column.getLength();
            precision = column.getPrecision();
            scale = column.getScale();
        }
        Value value = bootEntityDescriptor.getIdentifierProperty().getValue();
        return new BasicEntityIdentifierMappingImpl(this, templateInstanceCreator, bootEntityDescriptor.getIdentifierProperty().getName(), this.getTableName(), this.tableKeyColumns[0][0], columnDefinition, length, precision, scale, value.isColumnInsertable(0), value.isColumnUpdateable(0), (BasicType)idType, creationProcess);
    }

    @Override
    protected boolean isPhysicalDiscriminator() {
        return this.explicitDiscriminatorColumnName != null;
    }

    @Override
    protected EntityDiscriminatorMapping generateDiscriminatorMapping(PersistentClass bootEntityDescriptor, MappingModelCreationProcess modelCreationProcess) {
        EntityMappingType superMappingType = this.getSuperMappingType();
        if (superMappingType != null) {
            return superMappingType.getDiscriminatorMapping();
        }
        if (this.hasSubclasses()) {
            String formula = this.getDiscriminatorFormulaTemplate();
            if (this.explicitDiscriminatorColumnName != null || formula != null) {
                return super.generateDiscriminatorMapping(bootEntityDescriptor, modelCreationProcess);
            }
            return new CaseStatementDiscriminatorMappingImpl(this, this.subclassTableNameClosure, this.notNullColumnTableNumbers, this.notNullColumnNames, this.discriminatorValues, this.discriminatorAbstract, this.resolveDiscriminatorType(), modelCreationProcess);
        }
        return null;
    }

    @Override
    protected EntityIdentifierMapping generateNonEncapsulatedCompositeIdentifierMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        assert (this.declaredAttributeMappings != null);
        return MappingModelCreationHelper.buildNonEncapsulatedCompositeIdentifierMapping(this, this.getTableName(), this.tableKeyColumns[0], bootEntityDescriptor, creationProcess);
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new DynamicFilterAliasGenerator(this.subclassTableNameClosure, rootAlias);
    }

    @Override
    public TableDetails getMappedTableDetails() {
        return this.getTableMapping(this.getTableMappings().length - 1);
    }

    @Override
    public TableDetails getIdentifierTableDetails() {
        EntityMappingType superMappingType = this.getSuperMappingType();
        return superMappingType == null ? this.getMappedTableDetails() : this.getRootEntityDescriptor().getIdentifierTableDetails();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        if (this.hasSubclasses()) {
            EntityResultJoinedSubclassImpl entityResultJoinedSubclass = new EntityResultJoinedSubclassImpl(navigablePath, this, tableGroup, resultVariable);
            entityResultJoinedSubclass.afterInitialize(entityResultJoinedSubclass, creationState);
            return entityResultJoinedSubclass;
        }
        return super.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void pruneForSubclasses(TableGroup tableGroup, Map<String, EntityNameUse> entityNameUses) {
        HashSet<TableReference> retainedTableReferences = new HashSet<TableReference>(entityNameUses.size());
        MappingMetamodelImplementor metamodel = this.getFactory().getRuntimeMetamodels().getMappingMetamodel();
        boolean innerJoinOptimization = tableGroup.canUseInnerJoins() || tableGroup.isRealTableGroup();
        HashSet<String> tablesToInnerJoin = innerJoinOptimization ? new HashSet<String>() : null;
        boolean needsTreatDiscriminator = false;
        for (Map.Entry<String, EntityNameUse> entry : entityNameUses.entrySet()) {
            String tableName;
            TableReference mainTableReference;
            EntityNameUse.UseKind useKind = entry.getValue().getKind();
            JoinedSubclassEntityPersister persister = (JoinedSubclassEntityPersister)metamodel.findEntityDescriptor(entry.getKey());
            if (innerJoinOptimization && (useKind == EntityNameUse.UseKind.TREAT || useKind == EntityNameUse.UseKind.FILTER)) {
                int i;
                String[] subclassTableNames = persister.getSubclassTableNames();
                if (tablesToInnerJoin.isEmpty()) {
                    for (i = 0; i < subclassTableNames.length; ++i) {
                        if (!persister.isClassOrSuperclassTable[i]) continue;
                        tablesToInnerJoin.add(subclassTableNames[i]);
                    }
                } else {
                    tablesToInnerJoin.retainAll(Arrays.asList(subclassTableNames));
                }
                if (useKind == EntityNameUse.UseKind.FILTER && this.explicitDiscriminatorColumnName == null) {
                    for (i = 0; i < subclassTableNames.length; ++i) {
                        if (persister.isClassOrSuperclassTable[i]) continue;
                        String subclassTableName = subclassTableNames[i];
                        TableReference mainTableReference2 = tableGroup.getTableReference(null, subclassTableName, false);
                        if (mainTableReference2 == null) {
                            throw new UnknownTableReferenceException(subclassTableName, "Couldn't find table reference");
                        }
                        retainedTableReferences.add(mainTableReference2);
                    }
                }
            }
            if ((mainTableReference = tableGroup.getTableReference(null, tableName = persister.getTableName(), false)) != null) {
                retainedTableReferences.add(mainTableReference);
            }
            if (!this.needsDiscriminator()) continue;
            needsTreatDiscriminator = needsTreatDiscriminator || !persister.isAbstract() && !this.isTypeOrSuperType(persister) && useKind == EntityNameUse.UseKind.TREAT;
        }
        if (innerJoinOptimization && tablesToInnerJoin.isEmpty()) {
            String[] subclassTableNames = this.getSubclassTableNames();
            for (int i = 0; i < subclassTableNames.length; ++i) {
                if (!this.isClassOrSuperclassTable[i]) continue;
                tablesToInnerJoin.add(subclassTableNames[i]);
            }
        }
        List<TableReferenceJoin> tableReferenceJoins = tableGroup.getTableReferenceJoins();
        if (needsTreatDiscriminator) {
            if (tableReferenceJoins.isEmpty()) {
                String discriminatorPredicate = this.getPrunedDiscriminatorPredicate(entityNameUses, metamodel, "t");
                if (discriminatorPredicate != null) {
                    NamedTableReference tableReference = (NamedTableReference)tableGroup.getPrimaryTableReference();
                    tableReference.setPrunedTableExpression("(select * from " + this.getRootTableName() + " t where " + discriminatorPredicate + ")");
                }
            } else {
                boolean applied = this.applyDiscriminatorPredicate(tableReferenceJoins.get(0), (NamedTableReference)tableGroup.getPrimaryTableReference(), entityNameUses, metamodel);
                for (int i = 0; !applied && i < tableReferenceJoins.size(); ++i) {
                    TableReferenceJoin join2 = tableReferenceJoins.get(i);
                    applied = this.applyDiscriminatorPredicate(join2, join2.getJoinedTableReference(), entityNameUses, metamodel);
                }
                assert (applied) : "Could not apply treat discriminator predicate to root table join";
            }
        }
        if (tableReferenceJoins.isEmpty()) {
            return;
        }
        if (innerJoinOptimization) {
            TableReferenceJoin[] oldJoins = tableReferenceJoins.toArray(new TableReferenceJoin[0]);
            tableReferenceJoins.clear();
            block5: for (TableReferenceJoin oldJoin : oldJoins) {
                NamedTableReference joinedTableReference = oldJoin.getJoinedTableReference();
                if (retainedTableReferences.contains(joinedTableReference)) {
                    TableReferenceJoin join3 = oldJoin.getJoinType() != SqlAstJoinType.INNER && tablesToInnerJoin.contains(joinedTableReference.getTableExpression()) ? new TableReferenceJoin(true, joinedTableReference, oldJoin.getPredicate()) : oldJoin;
                    tableReferenceJoins.add(join3);
                    continue;
                }
                for (int i = this.subclassCoreTableSpan; i < this.subclassTableNameClosure.length; ++i) {
                    if (!joinedTableReference.getTableExpression().equals(this.subclassTableNameClosure[i])) continue;
                    tableReferenceJoins.add(oldJoin);
                    continue block5;
                }
            }
        } else {
            tableReferenceJoins.removeIf(join -> !retainedTableReferences.contains(join.getJoinedTableReference()));
        }
    }

    private boolean applyDiscriminatorPredicate(TableReferenceJoin join, NamedTableReference tableReference, Map<String, EntityNameUse> entityNameUses, MappingMetamodelImplementor metamodel) {
        if (tableReference.getTableExpression().equals(this.getRootTableName())) {
            assert (join.getJoinType() == SqlAstJoinType.INNER) : "Found table reference join with root table of non-INNER type: " + join.getJoinType();
            String discriminatorPredicate = this.getPrunedDiscriminatorPredicate(entityNameUses, metamodel, tableReference.getIdentificationVariable());
            join.applyPredicate(new SqlFragmentPredicate(discriminatorPredicate));
            return true;
        }
        return false;
    }

    @Override
    public void visitConstraintOrderedTables(EntityMappingType.ConstraintOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.constraintOrderedTableNames.length) {
            String tableName = this.constraintOrderedTableNames[i];
            int tablePosition = i++;
            consumer.consume(tableName, () -> columnConsumer -> columnConsumer.accept(tableName, this.constraintOrderedKeyColumnNames[tablePosition], this.getIdentifierMapping()::getJdbcMapping));
        }
    }
}

