/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.ConnectorUtils;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemoteOutboundConnectionService;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.remoting3.Endpoint;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.OptionMap;

class RemoteOutboundConnectionAdd
extends AbstractAddStepHandler {
    RemoteOutboundConnectionAdd() {
        super(RemoteOutboundConnectionResourceDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)resource);
        RemoteOutboundConnectionAdd.installRuntimeService(context, fullModel);
    }

    static void installRuntimeService(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        String outboundSocketBindingRef = RemoteOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.resolveModelAttribute(context, fullModel).asString();
        OptionMap connOpts = ConnectorUtils.getOptions(context, fullModel.get("property"));
        String username = RemoteOutboundConnectionResourceDefinition.USERNAME.resolveModelAttribute(context, fullModel).asStringOrNull();
        String authenticationContext = RemoteOutboundConnectionResourceDefinition.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, fullModel).asStringOrNull();
        String protocol = authenticationContext != null ? null : RemoteOutboundConnectionResourceDefinition.PROTOCOL.resolveModelAttribute(context, fullModel).asString();
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(AbstractOutboundConnectionResourceDefinition.OUTBOUND_CONNECTION_CAPABILITY);
        Consumer serviceConsumer = builder.provides(AbstractOutboundConnectionResourceDefinition.OUTBOUND_CONNECTION_CAPABILITY);
        Supplier osbSupplier = builder.requiresCapability("org.wildfly.network.outbound-socket-binding", OutboundSocketBinding.class, new String[]{outboundSocketBindingRef});
        Supplier acSupplier = authenticationContext != null ? builder.requiresCapability("org.wildfly.security.authentication-context", AuthenticationContext.class, new String[]{authenticationContext}) : null;
        builder.requiresCapability(RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY.getName(), Endpoint.class, new String[0]);
        builder.setInstance((Service)new RemoteOutboundConnectionService(serviceConsumer, osbSupplier, acSupplier, connOpts, username, protocol));
        builder.install();
    }
}

