/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.util.Nonbinding;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotation;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.util.collections.ImmutableSet;

public abstract class AbstractBindingModel<T extends Annotation>
extends AnnotationModel<T> {
    private Set<AnnotatedMethod<?>> nonBindingMembers;

    public AbstractBindingModel(EnhancedAnnotation<T> enhancedAnnotatedAnnotation) {
        super(enhancedAnnotatedAnnotation);
    }

    @Override
    protected void init(EnhancedAnnotation<T> annotatedAnnotation) {
        this.initNonBindingMembers(annotatedAnnotation);
        super.init(annotatedAnnotation);
    }

    protected void initNonBindingMembers(EnhancedAnnotation<T> annotatedAnnotation) {
        Set<EnhancedAnnotatedMethod<?, ?>> enhancedMethods = annotatedAnnotation.getMembers(Nonbinding.class);
        if (enhancedMethods.isEmpty()) {
            this.nonBindingMembers = Collections.emptySet();
        } else {
            ImmutableSet.Builder<AnnotatedMethod<?>> nonBindingMembers = ImmutableSet.builder();
            for (EnhancedAnnotatedMethod<?, ?> method : enhancedMethods) {
                nonBindingMembers.add(method.slim());
            }
            this.nonBindingMembers = nonBindingMembers.build();
        }
    }

    public Set<AnnotatedMethod<?>> getNonBindingMembers() {
        return this.nonBindingMembers;
    }
}

