/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordValidationException;

public class ValueRestriction
implements PasswordRestriction {
    private final Set<String> forbiddenValues;
    private final String requirementsMessage;
    private final boolean must;

    public ValueRestriction(String[] forbiddenValues, boolean must) {
        this.forbiddenValues = new HashSet<String>(Arrays.asList(forbiddenValues));
        this.must = must;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < forbiddenValues.length; ++i) {
            sb.append(forbiddenValues[i]);
            if (i + 1 >= forbiddenValues.length) continue;
            sb.append(", ");
        }
        this.requirementsMessage = must ? DomainManagementLogger.ROOT_LOGGER.passwordMustNotEqualInfo(sb.toString()) : DomainManagementLogger.ROOT_LOGGER.passwordShouldNotEqualInfo(sb.toString());
    }

    @Override
    public String getRequirementMessage() {
        return this.requirementsMessage;
    }

    @Override
    public void validate(String userName, String password) throws PasswordValidationException {
        if (this.forbiddenValues.contains(password)) {
            throw this.must ? DomainManagementLogger.ROOT_LOGGER.passwordMustNotBeEqual(password) : DomainManagementLogger.ROOT_LOGGER.passwordShouldNotBeEqual(password);
        }
    }
}

