/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public class PojoIndexingProcessorCastedTypeNode<T, U>
extends PojoIndexingProcessor<T> {
    private final PojoCaster<? super U> caster;
    private final Iterable<IndexObjectFieldReference> parentIndexObjectReferences;
    private final PojoIndexingProcessor<? super U> nested;
    private final boolean isEntityType;

    public PojoIndexingProcessorCastedTypeNode(PojoCaster<? super U> caster, Iterable<IndexObjectFieldReference> parentIndexObjectReferences, PojoIndexingProcessor<? super U> nested, boolean isEntityType) {
        this.caster = caster;
        this.parentIndexObjectReferences = parentIndexObjectReferences;
        this.nested = nested;
        this.isEntityType = isEntityType;
    }

    @Override
    public void close() {
        this.nested.close();
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.attribute("operation", (Object)"process type (with cast)");
        appender.attribute("caster", this.caster);
        appender.attribute("objectFieldsToCreate", this.parentIndexObjectReferences);
        appender.attribute("nested", this.nested);
        appender.attribute("isEntityType", (Object)this.isEntityType);
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorRootContext context) {
        if (source == null) {
            return;
        }
        source = context.sessionContext().runtimeIntrospector().unproxy(source);
        U castedSource = this.caster.cast(source);
        if (this.isEntityType && context.isDeleted(castedSource)) {
            return;
        }
        DocumentElement parentObject = target;
        for (IndexObjectFieldReference objectFieldReference : this.parentIndexObjectReferences) {
            parentObject = parentObject.addObject(objectFieldReference);
        }
        this.nested.process(parentObject, castedSource, context);
    }
}

